/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.relation.TbRelationQuery;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.service.provider.AttributeData;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface TbDataSource {
    public Flux<Device> findRelatedDevices(BusinessEntity var1, ViewRequest var2, ViewContext var3, TbRelationQuery var4, String var5, EntityId var6, String var7);

    public Flux<Asset> findRelatedAssets(BusinessEntity var1, ViewRequest var2, ViewContext var3, TbRelationQuery var4, String var5, EntityId var6, String var7);

    public Flux<Customer> findRelatedCustomers(BusinessEntity var1, ViewRequest var2, ViewContext var3, TbRelationQuery var4, String var5, EntityId var6, String var7);

    public Set<Asset> loadAssetsByType(BusinessEntity var1, ViewRequest var2, ViewContext var3, String var4, String var5);

    public Set<Asset> loadAssetsByTypeAndCustomer(BusinessEntity var1, ViewRequest var2, ViewContext var3, String var4, JwtSecUser var5, String var6);

    public Flux<Device> loadDevicesByType(BusinessEntity var1, ViewRequest var2, ViewContext var3, String var4, String var5);

    public Flux<Device> loadDevicesByTypeAndCustomer(BusinessEntity var1, ViewRequest var2, ViewContext var3, String var4, JwtSecUser var5, String var6);

    public Set<Customer> loadCustomers(BusinessEntity var1, ViewRequest var2, ViewContext var3, JwtSecUser var4, String var5);

    public Mono<List<Device>> loadDevicesByIdsAsync(Set<UUID> var1, String var2);

    public List<Device> loadDevicesByIds(Set<UUID> var1, String var2);

    public List<Asset> loadAssetsByIds(Set<UUID> var1, String var2);

    public Mono<Map<String, List<TsData>>> loadTelemetry(String var1, UUID var2, String var3, long var4, long var6, long var8, String var10, int var11, String var12);

    public Set<Item> loadItemsByQuery(EntityDataQuery var1, String var2);

    public List<EntitySubtype> loadAssetTypes(String var1);

    public List<EntitySubtype> loadDeviceTypes(String var1);

    public Flux<AttributeData> loadAttribute(String var1, UUID var2, String var3, String var4, String var5);

    public Mono<Map<String, List<TsData>>> loadLatestTelemetry(String var1, UUID var2, String var3, String var4);
}

