/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.TbBusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.relation.TbRelationQuery;
import org.thingsboard.trendz.domain.runtime.EnhancedCustomer;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;

@Component
public class TbCustomerService {
    private static final Logger log = LoggerFactory.getLogger(TbCustomerService.class);
    @Autowired
    private TbRestDataSource tbClient;

    public Flux<Item> loadCustomers(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, JwtSecUser secUser, String jwtToken) {
        Set customers = this.tbClient.loadCustomers(businessEntity, request, ctx, secUser, jwtToken);
        return Flux.fromIterable((Iterable)this.map((Collection)customers, null));
    }

    public Flux<Item> loadRelatedCustomers(UUID parentId, BusinessEntity parentEntity, ViewRequest request, ViewContext ctx, TbRelationQuery relationQuery, BusinessEntity relatedBusinessEntity, String jwtToken) {
        TbBusinessEntityQuery entityQuery = (TbBusinessEntityQuery)relatedBusinessEntity.getQuery();
        TbBusinessEntityQuery query = (TbBusinessEntityQuery)parentEntity.getQuery();
        AssetId parent = new AssetId(parentId);
        if (query.getEntityType().equals((Object)BusinessEntityType.DEVICE)) {
            parent = new DeviceId(parentId);
        } else if (query.getEntityType().equals((Object)BusinessEntityType.CUSTOMER)) {
            parent = new CustomerId(parentId);
        }
        Flux relatedCustomers = this.tbClient.findRelatedCustomers(relatedBusinessEntity, request, ctx, relationQuery, entityQuery.getType(), (EntityId)parent, jwtToken);
        return relatedCustomers.map(c -> {
            UUID ownerId = c.getOwnerId() != null ? c.getOwnerId().getId() : null;
            Item item = new Item(c.getUuidId(), parentId, ownerId, c.getName(), null);
            if (c instanceof EnhancedCustomer) {
                item.setAttributes(((EnhancedCustomer)c).getAttributes());
            }
            return item;
        });
    }

    private List<Item> map(Collection<Customer> customers, UUID parent) {
        List<Item> items = customers.stream().map(c -> {
            UUID ownerId = c.getOwnerId() != null ? c.getOwnerId().getId() : null;
            Item item = new Item(c.getUuidId(), parent, ownerId, c.getName(), null);
            if (c instanceof EnhancedCustomer) {
                item.setAttributes(((EnhancedCustomer)c).getAttributes());
            }
            return item;
        }).collect(Collectors.toList());
        return items;
    }
}

