/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.TbBusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.relation.TbRelationQuery;
import org.thingsboard.trendz.domain.runtime.EnhancedAsset;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;

@Component
public class TbAssetService {
    @Autowired
    private TbRestDataSource tbClient;

    public Flux<Item> loadAssets(TbBusinessEntityQuery query, BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String jwtToken) {
        Set assets = this.tbClient.loadAssetsByType(businessEntity, request, ctx, query.getType(), jwtToken);
        return this.map(Flux.fromIterable((Iterable)assets), null);
    }

    public Flux<Item> loadCustomerAssets(TbBusinessEntityQuery query, BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, JwtSecUser secUser, String jwtToken) {
        Set assets = this.tbClient.loadAssetsByTypeAndCustomer(businessEntity, request, ctx, query.getType(), secUser, jwtToken);
        return this.map(Flux.fromIterable((Iterable)assets), null);
    }

    public Flux<Item> loadRelatedAssets(UUID parentId, BusinessEntity parentEntity, ViewRequest request, ViewContext ctx, TbRelationQuery relationQuery, BusinessEntity relatedBusinessEntity, String jwtToken) {
        TbBusinessEntityQuery entityQuery = (TbBusinessEntityQuery)relatedBusinessEntity.getQuery();
        TbBusinessEntityQuery query = (TbBusinessEntityQuery)parentEntity.getQuery();
        AssetId parent = new AssetId(parentId);
        if (query.getEntityType().equals((Object)BusinessEntityType.DEVICE)) {
            parent = new DeviceId(parentId);
        } else if (query.getEntityType().equals((Object)BusinessEntityType.CUSTOMER)) {
            parent = new CustomerId(parentId);
        }
        Flux relatedAssets = this.tbClient.findRelatedAssets(relatedBusinessEntity, request, ctx, relationQuery, entityQuery.getType(), (EntityId)parent, jwtToken);
        return this.map(relatedAssets, parentId);
    }

    public Set<String> loadAssetTypes(String jwtToken) {
        return this.tbClient.loadAssetTypes(jwtToken).stream().map(EntitySubtype::getType).collect(Collectors.toSet());
    }

    public Set<Asset> loadAssetByType(String type, String jwtToken) {
        return this.tbClient.loadAssetsByType(null, null, null, type, jwtToken);
    }

    private Flux<Item> map(Flux<Asset> assets, UUID parent) {
        return assets.map(d -> {
            UUID ownerId = d.getOwnerId() != null ? d.getOwnerId().getId() : null;
            Item item = new Item(d.getUuidId(), parent, ownerId, d.getName(), d.getLabel());
            if (d instanceof EnhancedAsset) {
                item.setAttributes(((EnhancedAsset)d).getAttributes());
            }
            return item;
        });
    }
}

