/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.thingsboard.server.common.data.asset.AssetSearchQuery;
import org.thingsboard.server.common.data.device.DeviceSearchQuery;
import org.thingsboard.server.common.data.page.TextPageLink;
import org.thingsboard.trendz.service.provider.TbVersion;
import org.thingsboard.trendz.service.provider.TbVersionChecker;
import org.thingsboard.trendz.service.provider.tb3.PageLink;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;

@Component
public class TbApiSpec {
    private static final Logger log = LoggerFactory.getLogger(TbApiSpec.class);
    @Autowired
    private TbVersionChecker tbVersionChecker;

    public WebClient.RequestHeadersSpec<?> relatedDevices(WebClient webClient, String baseURL, DeviceSearchQuery query) {
        return ((WebClient.RequestBodySpec)webClient.post().uri(baseURL + "/api/devices", new Object[0])).body(BodyInserters.fromObject((Object)query));
    }

    public WebClient.RequestHeadersSpec<?> relatedAssets(WebClient webClient, String baseURL, AssetSearchQuery query) {
        return ((WebClient.RequestBodySpec)webClient.post().uri(baseURL + "/api/assets", new Object[0])).body(BodyInserters.fromObject((Object)query));
    }

    public WebClient.RequestHeadersSpec<?> assetTypes(WebClient webClient, String baseURL) {
        return webClient.get().uri(baseURL + "/api/asset/types", new Object[0]);
    }

    public WebClient.RequestHeadersSpec<?> deviceTypes(WebClient webClient, String baseURL) {
        return webClient.get().uri(baseURL + "/api/device/types", new Object[0]);
    }

    public WebClient.RequestHeadersSpec<?> relationByFrom(WebClient webClient, String baseURL, UUID fromId, String entityType) {
        return webClient.get().uri(baseURL + "/api/relations?fromId={fromId}&fromType={fromType}", new Object[]{fromId, entityType});
    }

    public WebClient.RequestHeadersSpec<?> attrKeys(WebClient webClient, String baseURL, String scope, String type, UUID id) {
        return webClient.get().uri(baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/keys/attributes/{scope}", new Object[]{type, id, scope});
    }

    public WebClient.RequestHeadersSpec<?> telemetryKeys(WebClient webClient, String baseURL, String type, UUID id) {
        return webClient.get().uri(baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/keys/timeseries", new Object[]{type, id});
    }

    public WebClient.RequestHeadersSpec<?> userAssetsV3(WebClient webClient, String baseURL, String jwtToken, PageLink pageLink, String assetType, UUID customerId) {
        Map params = this.searchParamsV3x(pageLink);
        params.put("type", assetType);
        String urlPath = "/api/user/assets?";
        String urlParams = "page={page}&pageSize={pageSize}&type={type}&textSearch={textSearch}&sortProperty={sortProperty}&sortOrder={sortOrder}";
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        if (version.isPe()) {
            urlPath = "/api/user/assets?";
        } else {
            params.put("customerId", customerId);
            urlPath = "/api/customer/{customerId}/assets?";
        }
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> userAssetsV2(WebClient webClient, String baseURL, String jwtToken, TextPageLink pageLink, String assetType, UUID customerId) {
        Map params = this.searchParamsV2x(pageLink);
        params.put("type", assetType);
        String urlParams = "limit={limit}&type={type}&idOffset={idOffset}&textOffset={textOffset}&textSearch={textSearch}";
        String urlPath = "/api/user/assets?";
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        if (version.isPe()) {
            urlPath = "/api/user/assets?";
        } else {
            params.put("customerId", customerId);
            urlPath = "/api/customer/{customerId}/assets?";
        }
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> tenantAssetsV2(WebClient webClient, String baseURL, String jwtToken, TextPageLink pageLink, String assetType) {
        Map params = this.searchParamsV2x(pageLink);
        params.put("type", assetType);
        String urlParams = "limit={limit}&type={type}&idOffset={idOffset}&textOffset={textOffset}&textSearch={textSearch}";
        String urlPath = "/api/tenant/assets?";
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> tenantAssetsV3(WebClient webClient, String baseURL, String jwtToken, PageLink pageLink, String assetType) {
        Map params = this.searchParamsV3x(pageLink);
        params.put("type", assetType);
        String urlParams = "page={page}&pageSize={pageSize}&type={type}&textSearch={textSearch}&sortProperty={sortProperty}&sortOrder={sortOrder}";
        String urlPath = "/api/tenant/assets?";
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> userDevicesV2(WebClient webClient, String baseURL, String jwtToken, TextPageLink pageLink, String deviceType, UUID customerId) {
        Map params = this.searchParamsV2x(pageLink);
        params.put("type", deviceType);
        String urlParams = "limit={limit}&type={type}&idOffset={idOffset}&textOffset={textOffset}&textSearch={textSearch}";
        String urlPath = "";
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        if (version.isPe()) {
            urlPath = "/api/user/devices?";
        } else {
            params.put("customerId", customerId);
            urlPath = "/api/customer/{customerId}/devices?";
        }
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> userEntitiesV31Filter(WebClient webClient, String baseURL, String jwtToken, EntityDataQuery query) {
        String urlPath = "/api/entitiesQuery/find";
        return ((WebClient.RequestBodySpec)webClient.post().uri(baseURL + urlPath, new Object[0])).body(BodyInserters.fromObject((Object)query));
    }

    public WebClient.RequestHeadersSpec<?> deviceByIds(WebClient webClient, String baseURL, String[] deviceIds) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("deviceIds", deviceIds);
        String urlParams = "deviceIds={deviceIds}";
        String urlPath = "/api/devices?";
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> assetByIds(WebClient webClient, String baseURL, String[] assetIds) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("assetIds", assetIds);
        String urlParams = "assetIds={assetIds}";
        String urlPath = "/api/assets?";
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> userDevicesV3(WebClient webClient, String baseURL, String jwtToken, PageLink pageLink, String deviceType, UUID customerId) {
        Map params = this.searchParamsV3x(pageLink);
        params.put("type", deviceType);
        String urlParams = "page={page}&pageSize={pageSize}&type={type}&textSearch={textSearch}&sortProperty={sortProperty}&sortOrder={sortOrder}";
        String urlPath = "";
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        if (version.isPe()) {
            urlPath = "/api/user/devices?";
        } else {
            params.put("customerId", customerId);
            urlPath = "/api/customer/{customerId}/devices?";
        }
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> tenantDevicesV2(WebClient webClient, String baseURL, String jwtToken, TextPageLink pageLink, String deviceType) {
        Map params = this.searchParamsV2x(pageLink);
        params.put("type", deviceType);
        String urlParams = "limit={limit}&type={type}&idOffset={idOffset}&textOffset={textOffset}&textSearch={textSearch}";
        String urlPath = "/api/tenant/devices?";
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> tenantDevicesV3(WebClient webClient, String baseURL, String jwtToken, PageLink pageLink, String deviceType) {
        Map params = this.searchParamsV3x(pageLink);
        params.put("type", deviceType);
        String urlParams = "page={page}&pageSize={pageSize}&type={type}&textSearch={textSearch}&sortProperty={sortProperty}&sortOrder={sortOrder}";
        String urlPath = "/api/tenant/devices?";
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> userCustomersV2(WebClient webClient, String baseURL, String jwtToken, TextPageLink pageLink, UUID customerId) {
        Map params = this.searchParamsV2x(pageLink);
        String urlParams = "limit={limit}&idOffset={idOffset}&textOffset={textOffset}&textSearch={textSearch}";
        String urlPath = "/api/user/customers?";
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        if (version.isPe()) {
            urlPath = "/api/user/customers?";
        } else {
            params.put("customerId", customerId);
            urlPath = "/api/customer/{customerId}";
            urlParams = "";
        }
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> userCustomersV3(WebClient webClient, String baseURL, String jwtToken, PageLink pageLink, UUID customerId) {
        Map params = this.searchParamsV3x(pageLink);
        String urlParams = "page={page}&pageSize={pageSize}&textSearch={textSearch}&sortProperty={sortProperty}&sortOrder={sortOrder}";
        String urlPath = "/api/user/customers?";
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        if (version.isPe()) {
            urlPath = "/api/user/customers?";
        } else {
            params.put("customerId", customerId);
            urlPath = "/api/customer/{customerId}";
            urlParams = "";
        }
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> tenantCustomersV2(WebClient webClient, String baseURL, String jwtToken, TextPageLink pageLink) {
        Map params = this.searchParamsV2x(pageLink);
        String urlParams = "limit={limit}&idOffset={idOffset}&textOffset={textOffset}&textSearch={textSearch}";
        String urlPath = "/api/customers?";
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    public WebClient.RequestHeadersSpec<?> tenantCustomersV3(WebClient webClient, String baseURL, String jwtToken, PageLink pageLink) {
        Map params = this.searchParamsV3x(pageLink);
        String urlParams = "page={page}&pageSize={pageSize}&textSearch={textSearch}&sortProperty={sortProperty}&sortOrder={sortOrder}";
        String urlPath = "/api/customers?";
        return webClient.get().uri(baseURL + urlPath + urlParams, params);
    }

    private Map<String, Object> searchParamsV2x(TextPageLink pageLink) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("limit", pageLink.getLimit());
        params.put("idOffset", pageLink.getIdOffset());
        params.put("textOffset", pageLink.getTextOffset());
        params.put("textSearch", pageLink.getTextSearch());
        return params;
    }

    private Map<String, Object> searchParamsV3x(PageLink pageLink) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", pageLink.getPageSize());
        params.put("page", pageLink.getPage());
        params.put("sortProperty", null);
        params.put("sortOrder", null);
        params.put("textSearch", null);
        return params;
    }
}

