/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.service.provider.PartitionBuilder;
import org.thingsboard.trendz.service.provider.TelemetryPartitionQuery;

@Service
public class PartitionBuilder {
    private static final Logger log = LoggerFactory.getLogger(PartitionBuilder.class);

    public List<TelemetryPartitionQuery> buildPartitionQueries(long startTs, long endTs, FieldAggregation fieldAggregation, DateAggregationType timeAggregation, boolean useOneSingleRawPartition) {
        if (useOneSingleRawPartition) {
            if (fieldAggregation == FieldAggregation.DELTA) {
                if (timeAggregation == null) {
                    long timeWindow = endTs - startTs;
                    return Lists.newArrayList((Object[])new TelemetryPartitionQuery[]{new TelemetryPartitionQuery(startTs - timeWindow, endTs, 0L, "NONE")});
                }
                ChronoUnit truncateUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)timeAggregation);
                ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTs), ZoneId.systemDefault());
                startDate = startDate.minus(1L, truncateUnit);
                startTs = startDate.toEpochSecond() * 1000L;
                return Lists.newArrayList((Object[])new TelemetryPartitionQuery[]{new TelemetryPartitionQuery(startTs, endTs, 0L, "NONE")});
            }
            return Lists.newArrayList((Object[])new TelemetryPartitionQuery[]{new TelemetryPartitionQuery(startTs, endTs, 0L, "NONE")});
        }
        if (fieldAggregation == FieldAggregation.DELTA && timeAggregation == null) {
            long timeWindow = endTs - startTs;
            return Lists.newArrayList((Object[])new TelemetryPartitionQuery[]{new TelemetryPartitionQuery(startTs - timeWindow, startTs - 1L, timeWindow, "MAX"), new TelemetryPartitionQuery(startTs, endTs, timeWindow, "MAX")});
        }
        if (timeAggregation == null || fieldAggregation == FieldAggregation.LATEST) {
            return Collections.singletonList(new TelemetryPartitionQuery(startTs, endTs, endTs - startTs, this.toStrAgg(fieldAggregation)));
        }
        if (fieldAggregation == FieldAggregation.DELTA && DateAggregationType.isLoadableAggregationType((DateAggregationType)timeAggregation)) {
            ChronoUnit truncateUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)timeAggregation);
            ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTs), ZoneId.systemDefault());
            startDate = startDate.minus(1L, truncateUnit);
            startTs = startDate.toEpochSecond() * 1000L;
        }
        int maxQueryCount = 500;
        if (Sets.newHashSet((Object[])new FieldAggregation[]{FieldAggregation.SUM, FieldAggregation.MAX, FieldAggregation.MIN, FieldAggregation.COUNT, FieldAggregation.AVG, FieldAggregation.DELTA}).contains(fieldAggregation) && DateAggregationType.isLoadableAggregationType((DateAggregationType)timeAggregation)) {
            ChronoUnit truncateUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)timeAggregation);
            return this.buildPartitions(startTs, endTs, (TemporalUnit)truncateUnit, maxQueryCount, fieldAggregation);
        }
        return Collections.singletonList(new TelemetryPartitionQuery(startTs, endTs, 0L, "NONE"));
    }

    private List<TelemetryPartitionQuery> buildPartitions(long startTs, long endTs, TemporalUnit truncateUnit, int maxIntervalCount, FieldAggregation fieldAggregation) {
        ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTs), ZoneId.systemDefault());
        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endTs), ZoneId.systemDefault());
        ZonedDateTime truncatedStart = DateAggregationType.extendedTruncateTo((ZonedDateTime)startDate, (TemporalUnit)truncateUnit);
        ZonedDateTime truncatedEnd = DateAggregationType.extendedTruncateTo((ZonedDateTime)endDate, (TemporalUnit)truncateUnit);
        ArrayList ranges = Lists.newArrayList();
        ranges.add(startTs);
        ZonedDateTime currentTruncatedTime = truncatedStart;
        while (!currentTruncatedTime.equals(truncatedEnd)) {
            ZonedDateTime nextTruncatedDate = currentTruncatedTime.plus(1L, truncateUnit);
            long nextTruncatedDateTs = nextTruncatedDate.toEpochSecond() * 1000L;
            ranges.add(nextTruncatedDateTs);
            currentTruncatedTime = nextTruncatedDate;
        }
        if (!truncatedEnd.equals(endDate)) {
            ranges.add(endTs);
        }
        ArrayList rawPartitions = Lists.newArrayList();
        Iterator rangeIterator = ranges.iterator();
        Long previousRange = (Long)rangeIterator.next();
        Long previousInterval = -1L;
        TelemetryPartitionQuery lastPartition = null;
        while (rangeIterator.hasNext()) {
            Long currentRange = (Long)rangeIterator.next();
            Long currentInterval = currentRange - previousRange;
            if (currentInterval.equals(previousInterval)) {
                lastPartition.setEndTs(currentRange.longValue());
            } else {
                lastPartition = new TelemetryPartitionQuery(previousRange.longValue(), currentRange.longValue(), currentInterval.longValue(), this.toStrAgg(fieldAggregation));
                rawPartitions.add(lastPartition);
            }
            previousRange = currentRange;
            previousInterval = currentInterval;
        }
        ArrayList partitions = Lists.newArrayList();
        rawPartitions.forEach(rawPartition -> {
            if ((rawPartition.getEndTs() - rawPartition.getStartTs()) / rawPartition.getInterval() > (long)maxIntervalCount) {
                partitions.addAll(this.splitBigIntervals(rawPartition.getStartTs(), rawPartition.getEndTs(), rawPartition.getInterval(), maxIntervalCount, this.toStrAgg(fieldAggregation)));
            } else {
                partitions.add(rawPartition);
            }
        });
        partitions.forEach(partition -> log.trace("Partition: {} ", partition));
        return partitions;
    }

    private String toStrAgg(FieldAggregation aggregation) {
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$FieldAggregation[aggregation.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return aggregation.name();
            }
            case 6: {
                return "MAX";
            }
        }
        return "NONE";
    }

    private List<TelemetryPartitionQuery> splitBigIntervals(long startTs, long endTs, long step, int maxQueries, String agg) {
        ArrayList partitions = Lists.newArrayList();
        long currStart = startTs;
        while (currStart < endTs) {
            long currEnd;
            int stepsCount = 0;
            for (currEnd = currStart; stepsCount < maxQueries && currEnd < endTs; currEnd += step, ++stepsCount) {
            }
            partitions.add(new TelemetryPartitionQuery(currStart, currEnd, step, agg));
            currStart = currEnd;
        }
        return partitions;
    }
}

