/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.service.predict.Point;

@Component
public class TbSimpleRegression {
    private static final Logger log = LoggerFactory.getLogger(TbSimpleRegression.class);

    public List<Point> predict(List<Point> learnSet, long predictStartTs, long predictEndTs, long step) {
        SimpleRegression sr = new SimpleRegression();
        learnSet.forEach(p -> sr.addData((double)p.getTs().longValue(), p.getValue().doubleValue()));
        ArrayList prediction = Lists.newArrayList();
        for (Point point : learnSet) {
            prediction.add(new Point(point.getTs(), Double.valueOf(sr.predict((double)point.getTs().longValue()))));
        }
        for (long currTs = predictStartTs + step; currTs <= predictEndTs; currTs += step) {
            prediction.add(new Point(Long.valueOf(currTs), Double.valueOf(sr.predict((double)currTs))));
        }
        return prediction;
    }
}

