/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict;

import com.cloudera.sparkts.models.ARIMA;
import com.cloudera.sparkts.models.ARIMAModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.service.predict.Point;

@Component
public class SparkArima {
    private static final Logger log = LoggerFactory.getLogger(SparkArima.class);

    public List<Point> predict(List<Point> learnSet, long predictStartTs, long predictEndTs, long step) {
        int forecastSize = (int)((predictEndTs - predictStartTs) / step);
        double[] y = new double[learnSet.size()];
        int index = 0;
        for (Point p : learnSet) {
            y[index] = p.getValue();
            ++index;
        }
        Vector tsvector = Vectors.dense((double[])y);
        ARIMAModel model = ARIMA.autoFit((Vector)tsvector, (int)1, (int)1, (int)1);
        Vector forecast = model.forecast(tsvector, forecastSize);
        ArrayList prediction = Lists.newArrayList();
        long currTs = predictStartTs + step;
        index = 0;
        for (double pred : forecast.toArray()) {
            if (index >= learnSet.size()) {
                prediction.add(new Point(Long.valueOf(currTs), Double.valueOf(pred)));
                currTs += step;
            } else {
                prediction.add(new Point(learnSet.get(index).getTs(), Double.valueOf(pred)));
            }
            ++index;
        }
        return prediction;
    }
}

