/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict;

import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.forecast.Forecast;
import com.github.signaflo.timeseries.model.arima.Arima;
import com.github.signaflo.timeseries.model.arima.ArimaOrder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.service.predict.Point;

@Component
public class SimpleArima {
    private static final Logger log = LoggerFactory.getLogger(SimpleArima.class);

    public List<Point> predict(List<Point> learnSet, long predictStartTs, long predictEndTs, long step) {
        double[] y = new double[learnSet.size()];
        int index = 0;
        for (Point p : learnSet) {
            y[index] = p.getValue();
            ++index;
        }
        TimeSeries ts = TimeSeries.from((double[])y);
        ArimaOrder modelOrder = ArimaOrder.order((int)0, (int)1, (int)1, (int)0, (int)1, (int)1);
        Arima model = Arima.model((TimeSeries)ts, (ArimaOrder)modelOrder);
        int forecastSize = (int)((predictEndTs - predictStartTs) / step);
        Forecast forecast = model.forecast(forecastSize);
        long currTs = predictStartTs + step;
        for (double pred : forecast.pointEstimates().asArray()) {
            learnSet.add(new Point(Long.valueOf(currTs), Double.valueOf(pred)));
            currTs += step;
        }
        return learnSet;
    }
}

