/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.service.predict.FFTLearn;
import org.thingsboard.trendz.service.predict.MovingAverage;
import org.thingsboard.trendz.service.predict.OLSRegression;
import org.thingsboard.trendz.service.predict.Point;
import org.thingsboard.trendz.service.predict.PredictionService;
import org.thingsboard.trendz.service.predict.SimpleArima;
import org.thingsboard.trendz.service.predict.SparkArima;
import org.thingsboard.trendz.service.predict.TbSimpleRegression;
import org.thingsboard.trendz.service.view.ViewContext;

@Service
public class PredictionService {
    private static final Logger log = LoggerFactory.getLogger(PredictionService.class);
    @Autowired
    private TbSimpleRegression tbSimpleRegression;
    @Autowired
    private OLSRegression olsRegression;
    @Autowired
    private MovingAverage movingAverage;
    @Autowired
    private FFTLearn fftLearn;
    @Autowired
    private SimpleArima simpleArima;
    @Autowired
    private SparkArima sparkArima;

    public List<FieldValue> enrichPrediction(ViewField field, List<FieldValue> original, ViewContext ctx) {
        if (CollectionUtils.isEmpty(original) || original.size() < 2 || original.get(0).getFieldType().equals((Object)FieldType.BLANK)) {
            return original;
        }
        original.sort(Comparator.comparingLong(FieldValue::getTs));
        List learnSet = this.toPoints(original);
        if (CollectionUtils.isEmpty((Collection)learnSet)) {
            return original;
        }
        long maxTs = learnSet.stream().mapToLong(Point::getTs).max().orElse(Long.MIN_VALUE);
        long predictTs = maxTs + TimeUnit.SECONDS.toMillis(field.getPredictionRangeSec());
        if (ctx.getMaxRealTs() < maxTs) {
            ctx.setMaxRealTs(maxTs);
        }
        long step = original.get(1).getTs() - original.get(0).getTs();
        List predict = this.predict(field, learnSet, maxTs, predictTs, step);
        return this.fromPoints(original, predict);
    }

    private List<Point> predict(ViewField viewField, List<Point> learnSet, long predictStartTs, long predictEndTs, long step) {
        ArrayList predict;
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$PredictionType[viewField.getPredictionMethod().ordinal()]) {
            case 1: {
                predict = this.sparkArima.predict(learnSet, predictStartTs, predictEndTs, step);
                break;
            }
            case 2: {
                predict = this.tbSimpleRegression.predict(learnSet, predictStartTs, predictEndTs, step);
                break;
            }
            case 3: {
                predict = this.olsRegression.predict(learnSet, predictStartTs, predictEndTs, step);
                break;
            }
            case 4: {
                predict = this.fftLearn.predict(learnSet, predictStartTs, predictEndTs, step);
                break;
            }
            default: {
                throw new IllegalStateException("Prediction method not implemented " + viewField.getPredictionMethod());
            }
        }
        if (!viewField.isIncludeHistoricalData()) {
            Point p;
            int futureIndex = 0;
            Iterator iterator = predict.iterator();
            while (iterator.hasNext() && !(p = (Point)iterator.next()).getTs().equals(learnSet.get(learnSet.size() - 1).getTs())) {
                ++futureIndex;
            }
            predict = predict.subList(futureIndex + 1, predict.size());
        } else {
            Point p;
            int futureIndex = 0;
            Iterator iterator = predict.iterator();
            while (iterator.hasNext() && !(p = (Point)iterator.next()).getTs().equals(learnSet.get(learnSet.size() - 1).getTs())) {
                ++futureIndex;
            }
            ArrayList v2 = Lists.newArrayList(learnSet);
            v2.addAll(predict.subList(futureIndex + 1, predict.size()));
            predict = v2;
        }
        return predict;
    }

    private List<Point> differentiate(List<Point> learnSet) {
        ArrayList diff = Lists.newArrayList();
        Point prev = learnSet.get(0);
        for (Point p : learnSet) {
            diff.add(new Point(p.getTs(), Double.valueOf(p.getValue() - prev.getValue())));
            prev = p;
        }
        return diff;
    }

    private void restoreDifferentiated(List<Point> current, List<Point> initial) {
        Point initialPoint = null;
        for (Point p : initial) {
            if (!p.getTs().equals(current.get(0).getTs())) continue;
            initialPoint = p;
            break;
        }
        Point prev = current.get(0);
        prev.setValue(Double.valueOf(prev.getValue() + initialPoint.getValue()));
        for (Point p : current) {
            if (p != prev) {
                p.setValue(Double.valueOf(p.getValue() + prev.getValue()));
            }
            prev = p;
        }
    }

    private List<FieldValue> fromPoints(List<FieldValue> original, List<Point> points) {
        FieldValue ref = original.get(0);
        ArrayList result = Lists.newArrayList();
        points.forEach(p -> result.add(new FieldValue(ref.getItems(), ref.getFieldType(), (Object)p.getValue(), p.getTs().longValue())));
        return result;
    }

    private List<Point> toPoints(List<FieldValue> original) {
        return original.stream().filter(Objects::nonNull).map(v -> new Point(Long.valueOf(v.getTs()), Double.valueOf((Double)v.getInnerValue()))).collect(Collectors.toList());
    }
}

