/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.service.predict.Point;

@Component
public class OLSRegression {
    private static final Logger log = LoggerFactory.getLogger(OLSRegression.class);

    public List<Point> predict(List<Point> learnSet, long predictStartTs, long predictEndTs, long step) {
        OLSMultipleLinearRegression ols = new OLSMultipleLinearRegression();
        double[] y = new double[learnSet.size()];
        double[][] x = new double[learnSet.size()][];
        int i = 0;
        for (Point p : learnSet) {
            y[i] = p.getValue();
            x[i] = new double[]{p.getTs().longValue()};
            ++i;
        }
        ols.newSampleData(y, (double[][])x);
        double[] coef = ols.estimateRegressionParameters();
        ArrayList prediction = Lists.newArrayList();
        for (Point point : learnSet) {
            prediction.add(new Point(point.getTs(), Double.valueOf(this.calculateEstimation((double)point.getTs().longValue(), coef))));
        }
        for (long currTs = predictStartTs + step; currTs <= predictEndTs; currTs += step) {
            prediction.add(new Point(Long.valueOf(currTs), Double.valueOf(this.calculateEstimation((double)currTs, coef))));
        }
        return prediction;
    }

    private double calculateEstimation(double x, double[] coe) {
        double result = 0.0;
        for (int i = 0; i < coe.length; ++i) {
            result += coe[i] * Math.pow(x, i);
        }
        return result;
    }
}

