/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.service.predict.Point;

@Component
public class MovingAverage {
    private static final Logger log = LoggerFactory.getLogger(MovingAverage.class);

    public List<Point> predict(List<Point> learnSet, long predictStartTs, long predictEndTs, long step) {
        int range = 10;
        ArrayList prediction = Lists.newArrayList();
        LinkedList<Double> window = new LinkedList<Double>();
        double sum = 0.0;
        for (Point p : learnSet) {
            sum += p.getValue().doubleValue();
            window.add(p.getValue());
            if (window.size() > range) {
                sum -= ((Double)window.remove()).doubleValue();
            }
            prediction.add(new Point(p.getTs(), Double.valueOf(sum / (double)window.size())));
        }
        return prediction;
    }
}

