/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.service.predict.Point;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class FFTLearn {
    private static final Logger log = LoggerFactory.getLogger(FFTLearn.class);

    public List<Point> predict(List<Point> learnSet, long predictStartTs, long predictEndTs, long step) {
        double[] values = new double[learnSet.size()];
        int index = 0;
        for (Point p : learnSet) {
            values[index] = p.getValue();
            ++index;
        }
        values = this.trimToPowerOfTwo(values);
        int indexDelta = learnSet.size() - values.length;
        int padSize = values.length - learnSet.size();
        WeightedObservedPoints qqq = new WeightedObservedPoints();
        index = 0;
        for (double v : values) {
            qqq.add((double)index, v);
            ++index;
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)1);
        double[] fit = fitter.fit((Collection)qqq.toList());
        index = 0;
        for (double v : values) {
            values[index] = values[index] - fit[1] * (double)index;
            ++index;
        }
        FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] complx = fft.transform(values, TransformType.FORWARD);
        ArrayList prediction = Lists.newArrayList();
        int harmonics = (int)((double)values.length * 0.1);
        if (harmonics > 100) {
            harmonics = 100;
        }
        int[] indexes = this.getSortedIndexes(values.length, harmonics);
        double[] freq = this.fftFreq(values.length);
        int forecastSize = (int)((predictEndTs - predictStartTs) / step);
        double[] restoredArray = new double[values.length + forecastSize];
        for (int i = 0; i < restoredArray.length; ++i) {
            restoredArray[i] = 0.0;
        }
        for (int i : indexes) {
            double amplitude = Math.abs(complx[i].abs()) / (double)values.length;
            double phase = Math.atan2(complx[i].getImaginary(), complx[i].getReal());
            for (int j = 0; j < restoredArray.length; ++j) {
                restoredArray[j] = restoredArray[j] + amplitude * Math.cos(Math.PI * 2 * freq[i] * (double)j + phase);
            }
        }
        long currTs = 0L;
        for (int i = 0; i < restoredArray.length; ++i) {
            if (i < padSize) continue;
            double v = restoredArray[i] + fit[1] * (double)i;
            if (i + indexDelta < learnSet.size()) {
                Long pointTs = learnSet.get(i + indexDelta).getTs();
                prediction.add(new Point(pointTs, Double.valueOf(v)));
                currTs = pointTs;
                continue;
            }
            prediction.add(new Point(Long.valueOf(currTs += step), Double.valueOf(v)));
        }
        return prediction;
    }

    private double[] padToPowerOfTwo(double[] original) {
        int nextLength = FFTLearn.nextPowerOf2((int)original.length);
        if (nextLength != original.length) {
            int index;
            double[] padded = new double[nextLength];
            for (index = 0; index < nextLength - original.length; ++index) {
                padded[index] = original[0];
            }
            double[] dArray = original;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double v;
                padded[index] = v = dArray[i];
                ++index;
            }
            return padded;
        }
        return original;
    }

    private double[] trimToPowerOfTwo(double[] original) {
        int currLength = original.length;
        int nextLength = FFTLearn.nextPowerOf2((int)currLength);
        if (currLength != nextLength) {
            --currLength;
            while (currLength != FFTLearn.nextPowerOf2((int)currLength)) {
                --currLength;
            }
            return Arrays.copyOfRange(original, original.length - currLength, original.length);
        }
        return original;
    }

    public static int nextPowerOf2(int a) {
        int b;
        for (b = 1; b < a; b <<= 1) {
        }
        return b;
    }

    private int[] getSortedIndexes(int n, int harmonics) {
        double[] freq = this.fftFreq(n);
        ArrayList pairs = Lists.newArrayList();
        int idnex = 0;
        for (double f : freq) {
            pairs.add(Pair.of((Object)idnex++, (Object)f));
        }
        pairs.sort(Comparator.comparingDouble(p -> Math.abs((Double)p.getRight())));
        int[] result = new int[1 + 2 * harmonics];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)((Pair)pairs.get(i)).getLeft();
        }
        return result;
    }

    private double[] fftFreq(int n) {
        int i;
        double val = 1.0 / (double)(n * 1);
        int N = (n - 1) / 2 + 1;
        double[] results = new double[n];
        int[] p1 = new int[N];
        for (int i2 = 0; i2 < p1.length; ++i2) {
            p1[i2] = i2;
        }
        int[] p2 = new int[n / 2 + 1];
        int value = -(n / 2);
        int index = 0;
        while (value <= 0) {
            p2[index++] = value++;
        }
        for (i = 0; i < N; ++i) {
            results[i] = (double)p1[i] * val;
        }
        for (i = 0; i < p2.length - 1; ++i) {
            results[i + N] = (double)p2[i] * val;
        }
        return results;
    }
}

