/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.install;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.service.install.EntityDatabaseSchemaService;

@Service
@Profile(value={"install"})
public class TrendzInstallService {
    private static final Logger log = LoggerFactory.getLogger(TrendzInstallService.class);
    @Value(value="${install.upgrade:false}")
    private Boolean isUpgrade;
    @Value(value="${install.upgrade.from_version:1.7.0}")
    private String upgradeFromVersion;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private EntityDatabaseSchemaService entityDatabaseSchemaService;

    public void performInstall() {
        try {
            if (this.isUpgrade.booleanValue()) {
                log.info("Start upgrading Trendz from version {} ...", (Object)this.upgradeFromVersion);
                switch (this.upgradeFromVersion) {
                    case "1.6.0": {
                        this.upgradeFromVersion = "1.6.0";
                        log.info("Upgrading Trendz from version 1.6.0 to 1.7.0 ...");
                        this.entityDatabaseSchemaService.upgradeDatabase(this.upgradeFromVersion);
                    }
                    case "1.7.0": {
                        this.upgradeFromVersion = "1.7.0";
                        log.info("Upgrading Trendz from version 1.7.0 to 1.8.0 ...");
                        this.entityDatabaseSchemaService.upgradeDatabase(this.upgradeFromVersion);
                    }
                    case "1.8.0": {
                        this.upgradeFromVersion = "1.8.0";
                        log.info("Current version is {}, upgrade is not needed.", (Object)this.upgradeFromVersion);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unable to upgrade Trendz, unsupported fromVersion: " + this.upgradeFromVersion);
                    }
                }
            } else {
                log.info("Starting Trendz Installation...");
                log.info("Installing DataBase schema for entities...");
                this.entityDatabaseSchemaService.createDatabaseSchema();
                log.info("Installation finished successfully!");
            }
        }
        catch (Exception e) {
            log.error("Unexpected error during Trendz installation!", (Throwable)e);
            throw new IllegalStateException("Unexpected error during Trendz installation!", e);
        }
        finally {
            SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        }
    }
}

