/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.install;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.BusinessEntityRepository;
import org.thingsboard.trendz.dao.ViewConfigRepository;
import org.thingsboard.trendz.service.install.EntityDatabaseSchemaService;
import org.thingsboard.trendz.service.install.HsqlMigrationData;
import org.thingsboard.trendz.service.install.HsqlToPostgresMigrator;

@Service
@Profile(value={"install"})
public class SqlEntityDatabaseSchemaService
implements EntityDatabaseSchemaService {
    private static final Logger log = LoggerFactory.getLogger(SqlEntityDatabaseSchemaService.class);
    private static final String SQL_DIR = "sql";
    private static final String UPGRADE_DIR = "upgrade";
    private static final String schemaSql = "schema-entities.sql";
    private static final String schemaIdxSql = "schema-entities-idx.sql";
    private static final String schemaUpdateSql = "schema_update.sql";
    @Value(value="${spring.datasource.url}")
    private String dbUrl;
    @Value(value="${spring.datasource.username}")
    private String dbUserName;
    @Value(value="${spring.datasource.password}")
    private String dbPassword;
    @Value(value="${install.data_dir:}")
    private String dataDir;
    @Autowired
    private BusinessEntityRepository businessEntityRepository;
    @Autowired
    private ViewConfigRepository viewConfigRepository;
    @Autowired
    private HsqlToPostgresMigrator migrator;

    public void createDatabaseSchema() throws Exception {
        log.info("Installing SQL DataBase schema part: schema-entities.sql");
        Path schemaFile = Paths.get(this.dataDir, SQL_DIR, schemaSql);
        this.launchScript(schemaFile);
        log.info("Installing SQL DataBase schema indexes part: schema-entities-idx.sql");
        Path schemaIdxFile = Paths.get(this.dataDir, SQL_DIR, schemaIdxSql);
        this.launchScript(schemaIdxFile);
    }

    public void upgradeDatabase(String fromVersion) {
        switch (fromVersion) {
            case "1.6.0": {
                try {
                    log.info("Starting update db......");
                    HsqlMigrationData migrationData = this.migrator.getMigrationData();
                    List businessEntities = migrationData.getBusinessEntities();
                    List viewConfigs = migrationData.getViewConfigs();
                    log.info("Start DB migration, in hsqldb found [{}] business entities and [{}] view configs", (Object)businessEntities.size(), (Object)viewConfigs.size());
                    Path schemaUpdateFile = Paths.get(this.dataDir, UPGRADE_DIR, fromVersion, schemaUpdateSql);
                    this.launchScript(schemaUpdateFile);
                    this.businessEntityRepository.saveAll((Iterable)businessEntities);
                    this.viewConfigRepository.saveAll((Iterable)viewConfigs);
                    log.info("DB migration finish!");
                    break;
                }
                catch (Exception e) {
                    log.error("Error during upgrading the database!", (Throwable)e);
                    throw new IllegalStateException("Error during upgrading the database!", e);
                }
            }
            case "1.7.0": {
                try {
                    log.info("Starting update db......");
                    Path schemaUpdateFile = Paths.get(this.dataDir, UPGRADE_DIR, fromVersion, schemaUpdateSql);
                    this.launchScript(schemaUpdateFile);
                    log.info("DB schema update finish!");
                    break;
                }
                catch (Exception e) {
                    log.error("Error during upgrading the database!", (Throwable)e);
                    throw new IllegalStateException("Error during upgrading the database!", e);
                }
            }
        }
        log.info("Upgrade finish!");
    }

    private void launchScript(Path pathToFile) throws SQLException, IOException {
        try (Connection conn = DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);){
            String sql = new String(Files.readAllBytes(pathToFile), StandardCharsets.UTF_8);
            conn.createStatement().execute(sql);
        }
    }
}

