/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.install;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.sql.BusinessEntityDto;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.sql.ViewConfigDto;
import org.thingsboard.trendz.dao.sql.ViewFieldDto;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.service.install.HsqlMigrationData;

@Service
public class HsqlToPostgresMigrator {
    private static final Logger log = LoggerFactory.getLogger(HsqlToPostgresMigrator.class);
    @Value(value="${hsql.datasource.url:jdbc:hsqldb:file:/usr/share/trendz/data/sql/trendzDB}")
    private String dbUrl;
    @Value(value="${hsql.datasource.username:sa}")
    private String dbUserName;
    @Value(value="${hsql.datasource.password:}")
    private String dbPassword;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HsqlMigrationData getMigrationData() {
        try (Connection connection = DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);){
            ResultSet resultSet = connection.createStatement().executeQuery("select * from public.business_entity");
            List businessEntities = this.getBusinessEntities(resultSet);
            ResultSet resultViewConfigSet = connection.createStatement().executeQuery("select * from public.view_config");
            List viewConfigs = this.getViewConfigs(resultViewConfigSet);
            HsqlMigrationData hsqlMigrationData = new HsqlMigrationData(businessEntities, viewConfigs);
            return hsqlMigrationData;
        }
        catch (Exception e) {
            log.error("Error during loading data from HSQLDB!", (Throwable)e);
            throw new IllegalStateException("Error during loading data from HSQLDB!", e);
        }
    }

    private List<BusinessEntityDto> getBusinessEntities(ResultSet resultSet) throws SQLException, IOException {
        ArrayList<BusinessEntityDto> result = new ArrayList<BusinessEntityDto>();
        while (resultSet.next()) {
            BusinessEntity businessEntity = (BusinessEntity)objectMapper.readValue(resultSet.getString("json_value"), BusinessEntity.class);
            BusinessEntityDto businessEntityDto = BusinessEntityDto.from((TenantId)new TenantId(UUID.fromString(resultSet.getString("tenant_id"))), (BusinessEntity)businessEntity);
            result.add(businessEntityDto);
        }
        return result;
    }

    private List<ViewConfigDto> getViewConfigs(ResultSet resultSet) throws SQLException, IOException {
        ArrayList<ViewConfigDto> result = new ArrayList<ViewConfigDto>();
        while (resultSet.next()) {
            ViewConfig viewConfig = (ViewConfig)objectMapper.readValue(resultSet.getString("json_value"), ViewConfig.class);
            ViewConfigDto viewConfigDto = ViewConfigDto.from((TenantId)new TenantId(UUID.fromString(resultSet.getString("tenant_id"))), (ViewConfig)viewConfig);
            for (ViewFieldDto viewFieldDto : viewConfigDto.getAllFields()) {
                UUID oldId = viewFieldDto.getId();
                UUID newId = TimeStampUUIDGenerator.generateId();
                viewFieldDto.setId(newId);
                List filters = viewConfigDto.getRuntimeFilters() != null ? (List)objectMapper.readValue(viewConfigDto.getRuntimeFilters(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */) : null;
                if (filters == null) continue;
                for (RuntimeFilterField filter : filters) {
                    if (!filter.getViewFieldId().equals(oldId)) continue;
                    filter.setViewFieldId(newId);
                    break;
                }
                String filtersDto = objectMapper.writeValueAsString((Object)filters);
                viewConfigDto.setRuntimeFilters(filtersDto);
            }
            result.add(viewConfigDto);
        }
        return result;
    }
}

