/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;

@Component
public class TopologyMergeService {
    private static final Logger log = LoggerFactory.getLogger(TopologyMergeService.class);

    public List<BusinessEntity> merge(Collection<BusinessEntity> oldTopo, Collection<BusinessEntity> newTopo) {
        HashMap<UUID, UUID> newToOldEntityId = new HashMap<UUID, UUID>();
        ArrayList mergedList = Lists.newArrayList();
        for (BusinessEntity newEntity : newTopo) {
            BusinessEntity oldEntity = this.findOldEntity(newEntity, oldTopo);
            if (oldEntity != null) {
                mergedList.add(this.mergeEntity(newEntity, oldEntity));
                newToOldEntityId.put(newEntity.getId(), oldEntity.getId());
                continue;
            }
            mergedList.add(newEntity);
        }
        this.fixIds((Collection)mergedList, newToOldEntityId);
        this.clearRemovedRelations((List)mergedList);
        return mergedList;
    }

    private void clearRemovedRelations(List<BusinessEntity> entities) {
        Map<UUID, BusinessEntity> entityMap = entities.stream().collect(Collectors.toMap(BusinessEntity::getId, e -> e));
        for (BusinessEntity entity : entities) {
            if (!CollectionUtils.isNotEmpty((Collection)entity.getRelations())) continue;
            Iterator iterator = entity.getRelations().iterator();
            while (iterator.hasNext()) {
                Relation relation = (Relation)iterator.next();
                if (entityMap.containsKey(relation.getRelatedEntityId())) continue;
                log.warn("Removed relation {} for {}", (Object)relation, (Object)entity.getName());
                iterator.remove();
            }
        }
    }

    private BusinessEntity mergeEntity(BusinessEntity newEntity, BusinessEntity oldEntity) {
        this.mergeRelations(newEntity, oldEntity);
        return this.mergeFields(newEntity, oldEntity);
    }

    private BusinessEntity mergeRelations(BusinessEntity newEntity, BusinessEntity oldEntity) {
        HashSet relations = Sets.newHashSet();
        if (oldEntity.getRelations() != null) {
            relations.addAll(oldEntity.getRelations());
        }
        if (newEntity.getRelations() != null) {
            relations.addAll(newEntity.getRelations());
        }
        oldEntity.setRelations((List)Lists.newArrayList((Iterable)relations));
        return oldEntity;
    }

    private BusinessEntity mergeFields(BusinessEntity newEntity, BusinessEntity oldEntity) {
        for (BusinessEntityField newEntityField : newEntity.getFields()) {
            BusinessEntityField oldField = this.findOldField(newEntityField, (Collection)oldEntity.getFields());
            if (oldField != null) continue;
            newEntityField.setBusinessEntityId(oldEntity.getId());
            oldEntity.getFields().add(newEntityField);
        }
        return oldEntity;
    }

    private BusinessEntity findOldEntity(BusinessEntity newEntity, Collection<BusinessEntity> oldTopo) {
        if (newEntity.getQuery() != null) {
            for (BusinessEntity oldEntity : oldTopo) {
                if (!newEntity.getQuery().equals(oldEntity.getQuery())) continue;
                return oldEntity;
            }
        }
        return null;
    }

    private BusinessEntityField findOldField(BusinessEntityField newField, Collection<BusinessEntityField> oldFields) {
        if (newField.getQuery() != null) {
            for (BusinessEntityField oldField : oldFields) {
                if (!newField.getQuery().equals(oldField.getQuery())) continue;
                return oldField;
            }
        }
        return null;
    }

    private void fixIds(Collection<BusinessEntity> merged, Map<UUID, UUID> newToOldEntityId) {
        for (BusinessEntity entity : merged) {
            if (entity.getRelations() == null) continue;
            for (Relation relation : entity.getRelations()) {
                if (!newToOldEntityId.containsKey(relation.getRelatedEntityId())) continue;
                relation.setRelatedEntityId(newToOldEntityId.get(relation.getRelatedEntityId()));
            }
            entity.setRelations((List)Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)entity.getRelations())));
        }
    }
}

