/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IdBased;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.InitStatus;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.TbBusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.entity.field.TbBusinessEntityFieldQuery;
import org.thingsboard.trendz.service.definition.DiscoverConfig;
import org.thingsboard.trendz.service.definition.DiscoveryCtx;
import org.thingsboard.trendz.service.definition.TbRelationDiscovery;
import org.thingsboard.trendz.service.definition.TopologyDiscovery;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbCustomerService;
import org.thingsboard.trendz.service.provider.TbDeviceService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

@Component
public class TbTopologyDiscovery
implements TopologyDiscovery {
    private static final Logger log = LoggerFactory.getLogger(TbTopologyDiscovery.class);
    @Autowired
    private TbRelationDiscovery relationDiscovery;
    @Autowired
    private TbAssetService assetService;
    @Autowired
    private TbDeviceService deviceService;
    @Autowired
    private TbCustomerService customerService;
    @Autowired
    private TbRestDataSource apiClient;

    public List<BusinessEntity> discoverTopology(DiscoverConfig discoverConfig, InitStatus status, String jwtToken) {
        log.info("Start New Topology Discovery");
        long startTs = System.currentTimeMillis();
        DiscoveryCtx ctx = new DiscoveryCtx();
        ArrayList businessEntities = Lists.newArrayList();
        businessEntities.addAll(this.fetchAssetSchema(discoverConfig, status, ctx, jwtToken));
        businessEntities.addAll(this.fetchDeviceSchema(discoverConfig, status, ctx, jwtToken));
        businessEntities.forEach(be -> be.getFields().forEach(f -> {
            f.setId(TimeStampUUIDGenerator.generateId());
            f.setBusinessEntityId(be.getId());
        }));
        this.relationDiscovery.discoverRelations((List)businessEntities, discoverConfig, status, jwtToken);
        for (Map.Entry entry : ctx.getStrFieldValues().asMap().entrySet()) {
            ((BusinessEntityField)entry.getKey()).setOptions((Set)Sets.newHashSet((Iterable)Iterables.limit((Iterable)((Iterable)entry.getValue()), (int)100)));
        }
        this.processOwners(ctx, jwtToken);
        long endTs = System.currentTimeMillis();
        log.info("Discovered topology has {} business entities. Found in {} ms", (Object)businessEntities.size(), (Object)(endTs - startTs));
        return businessEntities;
    }

    private List<BusinessEntity> fetchAssetSchema(DiscoverConfig discoverConfig, InitStatus status, DiscoveryCtx ctx, String jwtToken) {
        status.setCurrentState("Discover assets");
        ArrayList businessEntities = Lists.newArrayList();
        Set assetTypes = this.assetService.loadAssetTypes(jwtToken);
        log.info("Found asset types {}", (Object)assetTypes);
        status.setAssetTypes(status.getAssetTypes() + assetTypes.size());
        for (String assetType : assetTypes) {
            Set assets = this.assetService.loadAssetByType(assetType, jwtToken);
            status.setAssetsDetected(status.getAssetsDetected() + assets.size());
            log.info("Load {} assets for type {}", (Object)assets.size(), (Object)assetType);
            if (!CollectionUtils.isNotEmpty((Collection)assets)) continue;
            BusinessEntity assetBE = new BusinessEntity();
            assetBE.setId(TimeStampUUIDGenerator.generateId());
            assetBE.setName(assetType);
            TbBusinessEntityQuery query = new TbBusinessEntityQuery(BusinessEntityType.ASSET, assetType);
            assetBE.setQuery((BusinessEntityQuery)query);
            HashMap<String, BusinessEntityField> fields = new HashMap<String, BusinessEntityField>();
            BusinessEntityField nameField = this.buildField(ctx, assetType, FieldQueryType.ENTITY_NAME, null, (Object)"");
            ctx.addStrValues(nameField, (Collection)assets.stream().map(Asset::getName).collect(Collectors.toSet()));
            fields.put(nameField.getName() + System.currentTimeMillis(), nameField);
            if (assets.stream().anyMatch(a -> StringUtils.isNotBlank((CharSequence)a.getLabel()))) {
                BusinessEntityField labelField = this.buildField(ctx, assetType + " Label", FieldQueryType.ENTITY_LABEL, null, (Object)"");
                ctx.addStrValues(labelField, (Collection)assets.stream().map(Asset::getLabel).collect(Collectors.toSet()));
                fields.put(labelField.getName() + System.currentTimeMillis(), labelField);
            }
            BusinessEntityField ownerField = this.buildField(ctx, "Owner", FieldQueryType.OWNER, null, (Object)"");
            ctx.addOwnerIds(ownerField, (Collection)assets.stream().map(Asset::getOwnerId).collect(Collectors.toSet()));
            fields.put(ownerField.getName() + System.currentTimeMillis(), ownerField);
            ArrayList assetsToAnalyze = Lists.newArrayList((Iterable)assets);
            if (assets.size() >= discoverConfig.getMinItemToAnalyze()) {
                assetsToAnalyze = Lists.newArrayList();
                int analyzed = 0;
                for (Asset asset : assets) {
                    if (++analyzed % 100 >= discoverConfig.getAnalyzePercent()) continue;
                    assetsToAnalyze.add(asset);
                }
            }
            Flux.fromIterable((Iterable)assetsToAnalyze).flatMap(a -> this.fetchAssetFields(ctx, a, fields, jwtToken)).collectList().block();
            assetBE.setFields((List)Lists.newArrayList(fields.values()));
            status.setAssetsAnalyzed(status.getAssetsAnalyzed() + assets.size());
            businessEntities.add(assetBE);
        }
        log.info("Finish asset schema loading");
        return businessEntities;
    }

    private List<BusinessEntity> fetchDeviceSchema(DiscoverConfig discoverConfig, InitStatus status, DiscoveryCtx ctx, String jwtToken) {
        status.setCurrentState("Discover devices");
        ArrayList businessEntities = Lists.newArrayList();
        Set deviceTypes = this.deviceService.loadDeviceTypes(jwtToken);
        status.setDeviceTypes(status.getDeviceTypes() + deviceTypes.size());
        log.info("Found device types {}", (Object)deviceTypes);
        for (String deviceType : deviceTypes) {
            Set devices = this.deviceService.loadDeviceByType(deviceType, jwtToken);
            status.setDevicesDetected(status.getDevicesDetected() + devices.size());
            log.info("Load {} devices for type {}", (Object)devices.size(), (Object)deviceType);
            if (!CollectionUtils.isNotEmpty((Collection)devices)) continue;
            BusinessEntity deviceBE = new BusinessEntity();
            deviceBE.setId(TimeStampUUIDGenerator.generateId());
            deviceBE.setName(deviceType);
            TbBusinessEntityQuery query = new TbBusinessEntityQuery(BusinessEntityType.DEVICE, deviceType);
            deviceBE.setQuery((BusinessEntityQuery)query);
            ConcurrentHashMap<String, BusinessEntityField> fields = new ConcurrentHashMap<String, BusinessEntityField>();
            BusinessEntityField nameField = this.buildField(ctx, deviceType, FieldQueryType.ENTITY_NAME, null, (Object)"");
            ctx.addStrValues(nameField, (Collection)devices.stream().map(Device::getName).collect(Collectors.toSet()));
            fields.put(nameField.getName() + System.currentTimeMillis(), nameField);
            if (devices.stream().anyMatch(a -> StringUtils.isNotBlank((CharSequence)a.getLabel()))) {
                BusinessEntityField labelField = this.buildField(ctx, deviceType + " Label", FieldQueryType.ENTITY_LABEL, null, (Object)"");
                ctx.addStrValues(labelField, (Collection)devices.stream().map(Device::getLabel).collect(Collectors.toSet()));
                fields.put(labelField.getName() + System.currentTimeMillis(), labelField);
            }
            BusinessEntityField ownerField = this.buildField(ctx, "Owner", FieldQueryType.OWNER, null, (Object)"");
            ctx.addOwnerIds(ownerField, (Collection)devices.stream().map(Device::getOwnerId).collect(Collectors.toSet()));
            fields.put(ownerField.getName() + System.currentTimeMillis(), ownerField);
            ArrayList devicesToAnalyze = Lists.newArrayList((Iterable)devices);
            if (devices.size() >= discoverConfig.getMinItemToAnalyze()) {
                devicesToAnalyze = Lists.newArrayList();
                int analyzed = 0;
                for (Device device : devices) {
                    if (++analyzed % 100 >= discoverConfig.getAnalyzePercent()) continue;
                    devicesToAnalyze.add(device);
                }
            }
            Flux.fromIterable((Iterable)devicesToAnalyze).flatMap(d -> this.fetchDeviceFields(ctx, d, fields, jwtToken)).collectList().block();
            deviceBE.setFields((List)Lists.newArrayList(fields.values()));
            status.setDevicesAnalyzed(status.getDevicesAnalyzed() + devices.size());
            businessEntities.add(deviceBE);
        }
        log.info("Finish device schema loading");
        return businessEntities;
    }

    private Flux<Long> fetchAssetFields(DiscoveryCtx ctx, Asset asset, Map<String, BusinessEntityField> fields, String jwtToken) {
        return Flux.merge((Publisher[])new Publisher[]{this.fetchAttributeFields(ctx, "SERVER_SCOPE", EntityType.ASSET, asset.getUuidId(), fields, jwtToken), this.fetchTelemetryFields(ctx, EntityType.ASSET, asset.getUuidId(), fields, jwtToken)}).onErrorReturn((Object)-1L);
    }

    private Flux<Long> fetchDeviceFields(DiscoveryCtx ctx, Device device, Map<String, BusinessEntityField> fields, String jwtToken) {
        return Flux.merge((Publisher[])new Publisher[]{this.fetchAttributeFields(ctx, "CLIENT_SCOPE", EntityType.DEVICE, device.getUuidId(), fields, jwtToken), this.fetchAttributeFields(ctx, "SHARED_SCOPE", EntityType.DEVICE, device.getUuidId(), fields, jwtToken), this.fetchAttributeFields(ctx, "SERVER_SCOPE", EntityType.DEVICE, device.getUuidId(), fields, jwtToken), this.fetchTelemetryFields(ctx, EntityType.DEVICE, device.getUuidId(), fields, jwtToken)}).onErrorReturn((Object)-1L);
    }

    private Mono<Long> fetchAttributeFields(DiscoveryCtx ctx, String scope, EntityType entityType, UUID id, Map<String, BusinessEntityField> fields, String jwtToken) {
        return this.apiClient.findAttributeKeys(scope, entityType.name(), id, jwtToken).filter(key -> {
            String uniqKey = key + "_" + scope + "_attr";
            return !fields.containsKey(uniqKey);
        }).flatMap(key -> this.apiClient.loadAttribute(entityType.name(), id, scope, key, jwtToken)).map(attr -> this.buildField(ctx, attr.getKey(), FieldQueryType.ATTRIBUTE, scope, attr.getValue())).doOnNext(field -> fields.put(field.getName() + "_" + scope + "_attr", (BusinessEntityField)field)).count();
    }

    private Mono<Long> fetchTelemetryFields(DiscoveryCtx ctx, EntityType entityType, UUID id, Map<String, BusinessEntityField> fields, String jwtToken) {
        return this.apiClient.findTelemetryKeys(entityType.name(), id, jwtToken).filter(key -> {
            String uniqKey = key + "_ts_key";
            return !fields.containsKey(uniqKey);
        }).flatMap(key -> this.apiClient.loadLatestTelemetry(entityType.name(), id, key, jwtToken)).flatMap(map -> Flux.fromIterable(map.entrySet())).flatMap(entry -> Flux.fromStream(((List)entry.getValue()).stream().map(v -> Tuples.of(entry.getKey(), (Object)v.getValue())))).map(tuple -> this.buildField(ctx, (String)tuple.getT1(), FieldQueryType.TELEMETRY, null, tuple.getT2())).doOnNext(field -> fields.put(field.getName() + "_ts_key", (BusinessEntityField)field)).count();
    }

    private BusinessEntityField buildField(DiscoveryCtx ctx, String key, FieldQueryType queryType, String scope, Object value) {
        BusinessEntityField field = new BusinessEntityField();
        field.setId(TimeStampUUIDGenerator.generateId());
        field.setType(this.detectType(value.toString()));
        field.setName(key);
        field.setQuery((BusinessEntityFieldQuery)new TbBusinessEntityFieldQuery(queryType, key, scope));
        if (FieldQueryType.OWNER != queryType && field.getType() == FieldType.STRING && StringUtils.isNotBlank((CharSequence)value.toString())) {
            ctx.addStrValue(field, value.toString());
        }
        return field;
    }

    private FieldType detectType(String value) {
        if (NumberUtils.isParsable((String)value)) {
            long longVal;
            if (NumberUtils.isDigits((String)value) && (longVal = Long.parseLong(value)) > 315532800000L && longVal < 4102444800000L) {
                return FieldType.DATE;
            }
            return FieldType.NUMERIC;
        }
        if (value.toLowerCase().equals("true") || value.toLowerCase().equals("false")) {
            return FieldType.BOOLEAN;
        }
        return FieldType.STRING;
    }

    private void processOwners(DiscoveryCtx ctx, String jwtToken) {
        Map<UUID, String> dictionary = this.apiClient.loadCustomers(null, null, null, null, jwtToken).stream().collect(Collectors.toMap(IdBased::getUuidId, Customer::getName));
        dictionary.put(EntityId.NULL_UUID, "None");
        for (Map.Entry entry : ctx.getOwnerFieldValues().asMap().entrySet()) {
            TreeSet options = Sets.newTreeSet();
            for (EntityId entityId : (Collection)entry.getValue()) {
                String name = dictionary.get(entityId.getId());
                if (name != null) {
                    options.add(name);
                    continue;
                }
                if (!(entityId instanceof TenantId)) continue;
                options.add("Admin");
            }
            ((BusinessEntityField)entry.getKey()).setOptions((Set)Sets.newHashSet((Iterable)Iterables.limit((Iterable)options, (int)100)));
        }
    }
}

