/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationGraph;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationNode;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.definition.RelationGraphService;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

@Service
public class RelationGraphServiceImpl
implements RelationGraphService {
    @Autowired
    private BusinessEntityService businessEntityService;

    public RelationGraph getRelationGraph(TenantId tenantId, ViewRequest request) {
        Set affectedIds = this.additionalEntityIds(request);
        if (!affectedIds.isEmpty()) {
            request.getFields().forEach(f -> affectedIds.add(f.getBusinessEntityId()));
            return this.getRelationGraph(tenantId, affectedIds);
        }
        List entities = this.businessEntityService.getAllEntities(tenantId);
        Map<UUID, RelationNode> nodeMap = entities.stream().collect(Collectors.toMap(BusinessEntity::getId, e -> new RelationNode(e.getId(), e.getName())));
        RelationGraph graph = new RelationGraph();
        for (BusinessEntity entity : entities) {
            RelationNode node = nodeMap.get(entity.getId());
            if (CollectionUtils.isNotEmpty((Collection)entity.getRelations())) {
                for (Relation relation : entity.getRelations().stream().filter(Relation::isEnabled).collect(Collectors.toList())) {
                    RelationNode relatedNode = nodeMap.get(relation.getRelatedEntityId());
                    node.addDestination(relatedNode, relation);
                    relatedNode.addDestination(node, relation.revert(entity.getId()));
                }
            }
            graph.addNode(node);
        }
        return graph;
    }

    public RelationGraph getRelationGraph(TenantId tenantId, Set<UUID> affectedIds) {
        List entities = this.businessEntityService.getAllEntities(tenantId).stream().filter(be -> affectedIds.isEmpty() || affectedIds.contains(be.getId())).collect(Collectors.toList());
        Map<UUID, RelationNode> nodeMap = entities.stream().collect(Collectors.toMap(BusinessEntity::getId, e -> new RelationNode(e.getId(), e.getName())));
        RelationGraph graph = new RelationGraph();
        for (BusinessEntity entity : entities) {
            RelationNode node = nodeMap.get(entity.getId());
            if (CollectionUtils.isNotEmpty((Collection)entity.getRelations())) {
                for (Relation relation : entity.getRelations().stream().filter(Relation::isEnabled).collect(Collectors.toList())) {
                    if (!affectedIds.contains(relation.getRelatedEntityId())) continue;
                    RelationNode relatedNode = nodeMap.get(relation.getRelatedEntityId());
                    node.addDestination(relatedNode, relation);
                    relatedNode.addDestination(node, relation.revert(entity.getId()));
                }
            }
            graph.addNode(node);
        }
        return graph;
    }

    private Set<UUID> additionalEntityIds(ViewRequest request) {
        HashSet ids = Sets.newHashSet();
        JsonNode settings = request.getSettings();
        JsonNode missedGraphEntities = settings.get("missedGraphEntities");
        if (missedGraphEntities != null && !missedGraphEntities.isMissingNode()) {
            for (JsonNode node : (ArrayNode)missedGraphEntities) {
                UUID uuid = UUID.fromString(node.textValue());
                ids.add(uuid);
            }
        }
        return ids;
    }
}

