/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.domain.InitStatus;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.definition.DiscoverConfig;
import org.thingsboard.trendz.service.definition.InitializationService;
import org.thingsboard.trendz.service.definition.TopologyDiscovery;
import org.thingsboard.trendz.service.definition.TopologyMergeService;

@Service
public class InitializationServiceImpl
implements InitializationService {
    private static final Logger log = LoggerFactory.getLogger(InitializationServiceImpl.class);
    @Autowired
    private TopologyDiscovery topologyDiscovery;
    @Autowired
    private TopologyMergeService topologyMergeService;
    @Autowired
    private BusinessEntityService businessEntityService;
    private final Map<TenantId, InitStatus> tenantInitStatus = new ConcurrentHashMap();
    private final Map<TenantId, AtomicBoolean> tenantLoadStatus = new ConcurrentHashMap();
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    @PostConstruct
    public void init() {
        Set tenantIds = this.businessEntityService.findDiscoveredTenants();
        for (UUID id : tenantIds) {
            TenantId tenantId = new TenantId(id);
            this.tenantLoadStatus.put(tenantId, new AtomicBoolean(false));
            InitStatus status = new InitStatus();
            status.setInited(CollectionUtils.isNotEmpty((Collection)this.businessEntityService.getAllEntities(tenantId)));
            status.setInProgress(false);
            status.setDiscoverConfig(new DiscoverConfig(500, 5));
            this.tenantInitStatus.put(tenantId, status);
        }
        log.info("Found statuses for {} tenants", (Object)tenantIds.size());
    }

    @PreDestroy
    public void close() {
        this.executor.shutdownNow();
    }

    public InitStatus getInitStatus(TenantId tenantId) {
        return this.tenantInitStatus.computeIfAbsent(tenantId, id -> {
            InitStatus status = new InitStatus();
            status.setInited(false);
            status.setInProgress(false);
            status.setDiscoverConfig(new DiscoverConfig(500, 5));
            return status;
        });
    }

    public InitStatus initTopology(TenantId tenantId, DiscoverConfig discoverConfig, String jwtToken) {
        InitStatus status = this.getInitStatus(tenantId);
        this.executor.submit(() -> this.refreshTopology(tenantId, discoverConfig, jwtToken));
        try {
            TimeUnit.MILLISECONDS.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return status;
    }

    public InitStatus refreshTopology(TenantId tenantId, DiscoverConfig discoverConfig, String jwtToken) {
        InitStatus status = this.getInitStatus(tenantId);
        AtomicBoolean inProgress = this.tenantLoadStatus.computeIfAbsent(tenantId, id -> new AtomicBoolean(false));
        if (!inProgress.compareAndSet(false, true)) {
            throw new IllegalStateException("Other initialization request is in progress. Skip");
        }
        try {
            status.setFailed(false);
            status.setErrMessage(null);
            status.setInProgress(true);
            status.setAssetsAnalyzed(0);
            status.setAssetsDetected(0);
            status.setAssetTypes(0);
            status.setDeviceTypes(0);
            status.setDevicesDetected(0);
            status.setDevicesAnalyzed(0);
            status.setRelationsDetected(0);
            status.setStartTs(System.currentTimeMillis());
            status.setDiscoverConfig(discoverConfig);
            status.setCurrentState("Connecting");
            log.info("Start topology refresh");
            List oldEntities = this.businessEntityService.getAllEntities(tenantId);
            List freshTopology = this.topologyDiscovery.discoverTopology(discoverConfig, status, jwtToken);
            List mergedTopology = this.topologyMergeService.merge((Collection)oldEntities, (Collection)freshTopology);
            oldEntities.forEach(e -> this.businessEntityService.deleteEntity(tenantId, e.getId()));
            mergedTopology.forEach(e -> this.businessEntityService.save(tenantId, e));
            status.setInited(true);
            status.setCurrentState("Finished");
            log.info("Topology refresh finished for {}. Updated {} entities. Status {}", new Object[]{tenantId, mergedTopology.size(), status});
            InitStatus initStatus = status;
            return initStatus;
        }
        catch (Exception ex) {
            log.error("Topology refresh error", (Throwable)ex);
            status.setCurrentState("Failed - " + ex.getMessage());
            status.setErrMessage("Topology fetch failed - " + ex.getMessage());
            status.setFailed(true);
            throw new IllegalStateException(ex);
        }
        finally {
            status.setInProgress(false);
            inProgress.set(false);
        }
    }
}

