/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;

public class DiscoveryCtx {
    private Multimap<BusinessEntityField, String> strFieldValues = ArrayListMultimap.create();
    private Multimap<BusinessEntityField, EntityId> ownerFieldValues = ArrayListMultimap.create();

    public void addStrValue(BusinessEntityField field, String value) {
        this.strFieldValues.put((Object)field, (Object)value);
    }

    public void addStrValues(BusinessEntityField field, Collection<String> values) {
        this.strFieldValues.putAll((Object)field, values);
    }

    public void addOwnerIds(BusinessEntityField field, Collection<EntityId> ownerIds) {
        this.ownerFieldValues.putAll((Object)field, ownerIds);
    }

    public Multimap<BusinessEntityField, String> getStrFieldValues() {
        return this.strFieldValues;
    }

    public Multimap<BusinessEntityField, EntityId> getOwnerFieldValues() {
        return this.ownerFieldValues;
    }

    public void setStrFieldValues(Multimap<BusinessEntityField, String> strFieldValues) {
        this.strFieldValues = strFieldValues;
    }

    public void setOwnerFieldValues(Multimap<BusinessEntityField, EntityId> ownerFieldValues) {
        this.ownerFieldValues = ownerFieldValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiscoveryCtx)) {
            return false;
        }
        DiscoveryCtx other = (DiscoveryCtx)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Multimap this$strFieldValues = this.getStrFieldValues();
        Multimap other$strFieldValues = other.getStrFieldValues();
        if (this$strFieldValues == null ? other$strFieldValues != null : !this$strFieldValues.equals(other$strFieldValues)) {
            return false;
        }
        Multimap this$ownerFieldValues = this.getOwnerFieldValues();
        Multimap other$ownerFieldValues = other.getOwnerFieldValues();
        return !(this$ownerFieldValues == null ? other$ownerFieldValues != null : !this$ownerFieldValues.equals(other$ownerFieldValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DiscoveryCtx;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Multimap $strFieldValues = this.getStrFieldValues();
        result = result * 59 + ($strFieldValues == null ? 43 : $strFieldValues.hashCode());
        Multimap $ownerFieldValues = this.getOwnerFieldValues();
        result = result * 59 + ($ownerFieldValues == null ? 43 : $ownerFieldValues.hashCode());
        return result;
    }

    public String toString() {
        return "DiscoveryCtx(strFieldValues=" + this.getStrFieldValues() + ", ownerFieldValues=" + this.getOwnerFieldValues() + ")";
    }
}

