/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.BusinessEntityRepository;
import org.thingsboard.trendz.dao.sql.BusinessEntityDto;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.entity.relation.TbRelationQuery;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldFilterOption;
import org.thingsboard.trendz.service.definition.BusinessEntityService;

@Service
@Transactional
public class BusinessEntityServiceImpl
implements BusinessEntityService {
    private static final Logger log = LoggerFactory.getLogger(BusinessEntityServiceImpl.class);
    @Autowired
    private BusinessEntityRepository beRepository;

    public List<BusinessEntity> getAllEntities(TenantId tenantId) {
        return Lists.newArrayList((Iterable)this.beRepository.findAllByTenantId(tenantId.getId())).stream().map(BusinessEntityDto::toData).collect(Collectors.toList());
    }

    public BusinessEntity findEntityById(TenantId tenantId, UUID id) {
        BusinessEntityDto dto = this.beRepository.findByIdAndTenantId(id, tenantId.getId());
        if (dto == null) {
            throw new IllegalStateException("Business Entity not found by ID " + id + " and tenantId " + tenantId);
        }
        return dto.toData();
    }

    public BusinessEntityField findEntityFieldById(UUID id) {
        return this.beRepository.findFieldById(id).toData();
    }

    public UUID findEntityIdByName(String name, TenantId tenantId) {
        return this.beRepository.findIdByNameAndTenantId(name, tenantId.getId());
    }

    public BusinessEntityField findEntityFieldByNameAndEntityName(String fieldName, String entityName, TenantId tenantId) {
        return this.beRepository.findEntityFieldByNameAndEntityName(fieldName, entityName, tenantId.getId()).toData();
    }

    public BusinessEntity save(TenantId tenantId, BusinessEntity businessEntity) {
        if (businessEntity.getId() == null) {
            businessEntity.setId(TimeStampUUIDGenerator.generateId());
        }
        for (BusinessEntityField field : businessEntity.getFields()) {
            if (field.getId() == null) {
                field.setId(TimeStampUUIDGenerator.generateId());
            }
            if (field.getBusinessEntityId() != null) continue;
            field.setBusinessEntityId(businessEntity.getId());
        }
        if (businessEntity.getRelations() != null) {
            for (Relation relation : businessEntity.getRelations()) {
                ((TbRelationQuery)relation.getQuery()).setDistance(1);
            }
        }
        BusinessEntityDto from = BusinessEntityDto.from((TenantId)tenantId, (BusinessEntity)businessEntity);
        return ((BusinessEntityDto)this.beRepository.save((Object)from)).toData();
    }

    public void updateFieldOptions(TenantId tenantId, List<FieldFilterOption> options, List<ViewField> viewFields) {
        if (options.isEmpty()) {
            return;
        }
        List allEntities = this.getAllEntities(tenantId);
        Map<UUID, BusinessEntity> entityMap = allEntities.stream().collect(Collectors.toMap(BusinessEntity::getId, f -> f));
        Map<UUID, BusinessEntityField> fieldMap = allEntities.stream().flatMap(be -> be.getFields().stream()).collect(Collectors.toMap(BusinessEntityField::getId, f -> f));
        Map<UUID, ViewField> viewFieldMap = viewFields.stream().collect(Collectors.toMap(ViewField::getId, f -> f));
        ArrayList changedEntities = Lists.newArrayList();
        for (FieldFilterOption fieldOptions : options) {
            if (fieldOptions.getOptions().isEmpty()) continue;
            BusinessEntityField entityField = fieldMap.get(viewFieldMap.get(fieldOptions.getViewFieldId()).getEntityFieldId());
            Set oldOptions = entityField.getOptions();
            if (oldOptions == null) {
                oldOptions = Sets.newHashSet();
            }
            HashSet mergedOptions = Sets.newHashSet();
            mergedOptions.addAll(fieldOptions.getOptions());
            if (oldOptions.size() == mergedOptions.size() || oldOptions.size() >= 100) continue;
            entityField.setOptions((Set)Sets.newHashSet((Iterable)Iterables.limit((Iterable)mergedOptions, (int)100)));
            changedEntities.add(entityMap.get(entityField.getBusinessEntityId()));
        }
        if (!changedEntities.isEmpty()) {
            for (BusinessEntity entity : Sets.newHashSet((Iterable)changedEntities)) {
                this.save(tenantId, entity);
            }
        }
    }

    public boolean deleteEntity(TenantId tenantId, UUID id) {
        this.beRepository.deleteByIdAndTenantId(id, tenantId.getId());
        return true;
    }

    public Set<UUID> findDiscoveredTenants() {
        HashSet tenantIds = Sets.newHashSet();
        for (BusinessEntityDto dto : this.beRepository.findAll()) {
            tenantIds.add(dto.getTenantId());
        }
        return tenantIds;
    }
}

