/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.cache;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.thingsboard.trendz.service.cache.TimeRange;

public class TimeRange {
    private long startTs;
    private long endTs;

    public String toString() {
        return "TimeRange(startTs= " + this.startTs + " [" + ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.startTs), ZoneId.systemDefault()) + "], endTs= " + this.endTs + " [" + ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.endTs), ZoneId.systemDefault()) + "], ";
    }

    public static TimeRangeBuilder builder() {
        return new TimeRangeBuilder();
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        return this.getEndTs() == other.getEndTs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeRange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        return result;
    }

    public TimeRange() {
    }

    public TimeRange(long startTs, long endTs) {
        this.startTs = startTs;
        this.endTs = endTs;
    }
}

