/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;

public class PreloadedCache {
    private Map<String, Map<FieldAggregation, Map<UUID, List<CachedTelemetry>>>> cacheMap = new ConcurrentHashMap();

    public boolean containsCache(ViewField viewField, UUID itemId) {
        String fieldKey = this.getViewFieldKey(viewField);
        FieldAggregation fieldAggregation = viewField.getAggregationType();
        if (this.cacheMap.containsKey(fieldKey) && ((Map)this.cacheMap.get(fieldKey)).containsKey(fieldAggregation)) {
            return ((Map)((Map)this.cacheMap.get(fieldKey)).get(fieldAggregation)).containsKey(itemId);
        }
        return false;
    }

    public List<CachedTelemetry> getCache(ViewField viewField, UUID itemId) {
        String fieldKey = this.getViewFieldKey(viewField);
        FieldAggregation fieldAggregation = viewField.getAggregationType();
        if (this.cacheMap.containsKey(fieldKey) && ((Map)this.cacheMap.get(fieldKey)).containsKey(fieldAggregation) && ((Map)((Map)this.cacheMap.get(fieldKey)).get(fieldAggregation)).containsKey(itemId)) {
            return (List)((Map)((Map)this.cacheMap.get(fieldKey)).get(fieldAggregation)).get(itemId);
        }
        return null;
    }

    public void addCache(ViewField viewField, UUID itemId, CachedTelemetry cacheList) {
        String fieldKey = this.getViewFieldKey(viewField);
        FieldAggregation fieldAggregation = viewField.getAggregationType();
        this.cacheMap.computeIfAbsent(fieldKey, i -> new ConcurrentHashMap()).computeIfAbsent(fieldAggregation, i -> new ConcurrentHashMap()).computeIfAbsent(itemId, i -> new CopyOnWriteArrayList()).add(cacheList);
    }

    public void resetCache(ViewField viewField, UUID itemId) {
        String fieldKey = this.getViewFieldKey(viewField);
        FieldAggregation fieldAggregation = viewField.getAggregationType();
        if (this.cacheMap.containsKey(fieldKey) && ((Map)this.cacheMap.get(fieldKey)).containsKey(fieldAggregation) && ((Map)((Map)this.cacheMap.get(fieldKey)).get(fieldAggregation)).containsKey(itemId)) {
            ((Map)((Map)this.cacheMap.get(fieldKey)).get(fieldAggregation)).put(itemId, new ArrayList());
        }
    }

    private String getViewFieldKey(ViewField viewField) {
        if (viewField.isBatchCalculation()) {
            return viewField.getCalcFunction();
        }
        if (viewField.isStateField()) {
            return viewField.getStateCondition();
        }
        return viewField.getEntityFieldId().toString();
    }
}

