/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.cache;

import com.google.common.collect.Lists;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.ml.CachedTelemetryDaoAsync;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.cache.CachedTelemetryPoint;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.service.cache.TimeRange;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CachedTelemetryService {
    private static final Logger log = LoggerFactory.getLogger(CachedTelemetryService.class);
    @Autowired
    private CachedTelemetryDaoAsync cachedTelemetryDaoAsync;

    public Mono<List<CachedTelemetry>> loadAllCompatibleCachedTelemetry(Set<UUID> itemIds, long startTs, long endTs, ViewField viewField, DateAggregationType cachingDateAggregation) {
        ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTs), ZoneId.systemDefault());
        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endTs + 1L), ZoneId.systemDefault());
        ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)cachingDateAggregation);
        if (timeUnit.between(startDate, endDate) == 0L) {
            throw new IllegalArgumentException("Queried telemetry cache has time-range shorter than duration of aggregation time unit");
        }
        DateAggregationType equalDateAggregationType = DateAggregationType.getEqualByDurationForCaching((DateAggregationType)cachingDateAggregation);
        String function = CachedTelemetryService.getFunctionFromField((ViewField)viewField);
        return this.cachedTelemetryDaoAsync.findAllCompatibleCachedTelemetriesAsync(itemIds, startTs, endTs, viewField.getAggregationType(), equalDateAggregationType, viewField.getEntityFieldId(), function);
    }

    public CachedTelemetry mergeCachedTelemetries(List<CachedTelemetry> telemetryList, TenantId tenantId) {
        if (telemetryList.isEmpty()) {
            throw new IllegalArgumentException("Telemetry cache list is empty therefore there is nothing to merge.");
        }
        if (telemetryList.size() == 1) {
            CachedTelemetry copy = new CachedTelemetry(telemetryList.get(0));
            copy.setId(null);
            return copy;
        }
        long finalStartTs = telemetryList.stream().mapToLong(CachedTelemetry::getStartTs).min().orElseThrow(IllegalStateException::new);
        long finalEndTs = telemetryList.stream().mapToLong(CachedTelemetry::getEndTs).max().orElseThrow(IllegalStateException::new);
        long earliestUploadTime = telemetryList.stream().mapToLong(CachedTelemetry::getUploadTime).min().orElseThrow(IllegalStateException::new);
        CachedTelemetry exampleOfCompatibleCache = telemetryList.get(0);
        List mergedPointList = this.mergeToPointList(telemetryList);
        return CachedTelemetry.builder().itemId(exampleOfCompatibleCache.getItemId()).tenantId(tenantId.getId()).uploadTime(earliestUploadTime).calculatedField(exampleOfCompatibleCache.isCalculatedField()).stateField(exampleOfCompatibleCache.isStateField()).startTs(finalStartTs).endTs(finalEndTs).fieldType(exampleOfCompatibleCache.getFieldType()).fieldAggregation(exampleOfCompatibleCache.getFieldAggregation()).dateAggregationType(exampleOfCompatibleCache.getDateAggregationType()).businessEntityId(exampleOfCompatibleCache.getBusinessEntityId()).businessEntityFieldId(exampleOfCompatibleCache.getBusinessEntityFieldId()).calculatedOrStateFunction(exampleOfCompatibleCache.getCalculatedOrStateFunction()).points(mergedPointList).build();
    }

    public List<TimeRange> findGapsBetweenCaches(List<CachedTelemetry> telemetryList, long startTs, long endTs) {
        if (telemetryList.isEmpty()) {
            return Lists.newArrayList((Object[])new TimeRange[]{new TimeRange(startTs, endTs)});
        }
        List sortedTelemetryList = telemetryList.stream().sorted(Comparator.comparingLong(CachedTelemetry::getStartTs)).collect(Collectors.toList());
        CachedTelemetry first = (CachedTelemetry)sortedTelemetryList.get(0);
        CachedTelemetry last = (CachedTelemetry)sortedTelemetryList.get(sortedTelemetryList.size() - 1);
        long firstStart = first.getStartTs();
        long lastEnd = last.getEndTs();
        long prevEndTs = first.getEndTs();
        ArrayList<TimeRange> resultTimeRangeList = new ArrayList<TimeRange>();
        if (startTs < firstStart) {
            resultTimeRangeList.add(new TimeRange(startTs, firstStart));
        }
        for (CachedTelemetry cachedTelemetry : sortedTelemetryList) {
            if (prevEndTs < cachedTelemetry.getStartTs()) {
                resultTimeRangeList.add(new TimeRange(prevEndTs, cachedTelemetry.getStartTs()));
            }
            prevEndTs = cachedTelemetry.getEndTs();
        }
        if (lastEnd < endTs) {
            resultTimeRangeList.add(new TimeRange(lastEnd, endTs));
        }
        return resultTimeRangeList;
    }

    public Mono<Boolean> persistCashAndRemoveOthers(CachedTelemetry resultCachedTelemetry, List<CachedTelemetry> oldCachedTelemetryList) {
        return this.cachedTelemetryDaoAsync.saveOneAndRemoveListAsync(resultCachedTelemetry, oldCachedTelemetryList);
    }

    public Mono<Boolean> persistTelemetry(CachedTelemetry cachedTelemetry) {
        return this.cachedTelemetryDaoAsync.saveCachedTelemetryAsync(cachedTelemetry);
    }

    public Mono<Boolean> removeAllCacheByTenantId(TenantId tenantId) {
        return this.cachedTelemetryDaoAsync.removeAllByTenantIdAsync(tenantId);
    }

    public Mono<Boolean> removeAllCache() {
        return this.cachedTelemetryDaoAsync.removeAllCacheAsync();
    }

    private List<CachedTelemetryPoint> mergeToPointList(List<CachedTelemetry> telemetryList) {
        HashMap<Long, CachedTelemetryPoint> aggregatedTimestampToPointList = new HashMap<Long, CachedTelemetryPoint>();
        for (CachedTelemetry cache : telemetryList) {
            for (CachedTelemetryPoint cachePoint : cache.getPoints()) {
                if (aggregatedTimestampToPointList.containsKey(cachePoint.getTs())) {
                    throw new IllegalStateException("Telemetry caches are intersects, so there is unexpected behavior.");
                }
                aggregatedTimestampToPointList.putIfAbsent(cachePoint.getTs(), cachePoint);
            }
        }
        return aggregatedTimestampToPointList.values().stream().sorted(Comparator.comparingLong(CachedTelemetryPoint::getTs)).collect(Collectors.toList());
    }

    public static String getFunctionFromField(ViewField viewField) {
        if (viewField.isStateField()) {
            return viewField.getStateCondition();
        }
        if (viewField.isCalculatedField()) {
            return viewField.getCalcFunction();
        }
        return null;
    }
}

