/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.ViewConfigRepository;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.sql.ViewConfigDto;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.scheduledtask.ScheduledJob;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTask;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskService;
import org.thingsboard.trendz.service.scheduledtask.SchedulingConfig;
import org.thingsboard.trendz.service.scheduledtask.cache.CacheRefreshJob;

@Service
public class ViewConfigServiceImpl
implements ViewConfigService {
    private static final Logger log = LoggerFactory.getLogger(ViewConfigServiceImpl.class);
    @Autowired
    private ViewConfigRepository viewConfigRepository;
    @Autowired
    private ScheduledTaskService scheduledTaskService;

    public List<ViewConfig> getAll(TenantId tenantId) {
        return Lists.newArrayList((Iterable)this.viewConfigRepository.findAllByTenantId(tenantId.getId())).stream().map(ViewConfigDto::toData).collect(Collectors.toList());
    }

    public ViewConfig findConfigById(TenantId tenantId, UUID id) {
        return this.viewConfigRepository.findByIdAndTenantId(id, tenantId.getId()).toData();
    }

    public ViewConfig save(TenantId tenantId, ViewConfig viewConfig) {
        if (viewConfig.getId() == null) {
            viewConfig.setCreatedAt(System.currentTimeMillis());
            viewConfig.setId(TimeStampUUIDGenerator.generateId());
            ArrayList fields = Lists.newArrayList();
            fields.addAll(viewConfig.getyAxis());
            fields.addAll(viewConfig.getxAxis());
            fields.addAll(viewConfig.getSeries());
            fields.addAll(viewConfig.getHiddenFields());
            HashMap oldIdMap = new HashMap();
            fields.forEach(f -> {
                UUID newId = TimeStampUUIDGenerator.generateId();
                oldIdMap.put(f.getId(), newId);
                f.setId(newId);
            });
            if (CollectionUtils.isNotEmpty((Collection)viewConfig.getRuntimeFilters())) {
                viewConfig.getRuntimeFilters().forEach(rf -> {
                    UUID updatedId = (UUID)oldIdMap.get(rf.getViewFieldId());
                    if (updatedId != null) {
                        rf.setViewFieldId(updatedId);
                    }
                });
            }
        }
        viewConfig.setUpdatedAt(System.currentTimeMillis());
        ViewConfigDto from = ViewConfigDto.from((TenantId)tenantId, (ViewConfig)viewConfig);
        ViewConfig savedConfig = ((ViewConfigDto)this.viewConfigRepository.save((Object)from)).toData();
        this.processCachingJob(tenantId, savedConfig);
        return savedConfig;
    }

    public boolean delete(TenantId tenantId, UUID id) {
        ViewConfigDto configDto = this.viewConfigRepository.findByIdAndTenantId(id, tenantId.getId());
        if (configDto.getTaskId() != null) {
            this.scheduledTaskService.deleteTask(configDto.getTaskId());
        }
        this.viewConfigRepository.deleteByIdAndTenantId(id, tenantId.getId());
        return true;
    }

    private void processCachingJob(TenantId tenantId, ViewConfig viewConfig) {
        CacheSettings cacheSettings = viewConfig.getCacheSettings();
        if (cacheSettings == null || StringUtils.isBlank((CharSequence)cacheSettings.getRefreshFrequencyTimeUnit())) {
            return;
        }
        if (cacheSettings.getTaskId() != null) {
            ScheduledTask loadedTask = this.scheduledTaskService.getTaskById(cacheSettings.getTaskId());
            SchedulingConfig schedulingConfig = this.generateSchedulingConfig(cacheSettings);
            loadedTask.setEnabled(cacheSettings.isAutoRefreshCache());
            loadedTask.setSchedulingConfig(schedulingConfig);
            ScheduledTask scheduledTask = this.scheduledTaskService.updateTask(loadedTask);
        } else if (cacheSettings.isAutoRefreshCache()) {
            long firstRefreshTime = viewConfig.getDatePickerConfig().getStartTs();
            CacheRefreshJob job = CacheRefreshJob.builder().id(TimeStampUUIDGenerator.generateId()).viewConfigId(viewConfig.getId()).lastRefreshTime(firstRefreshTime).build();
            SchedulingConfig schedulingConfig = this.generateSchedulingConfig(cacheSettings);
            ScheduledTask newTask = this.scheduledTaskService.createTask(schedulingConfig, (List)Lists.newArrayList((Object[])new ScheduledJob[]{job}), true);
            viewConfig.getCacheSettings().setTaskId(newTask.getId());
            ViewConfigDto from = ViewConfigDto.from((TenantId)tenantId, (ViewConfig)viewConfig);
            ViewConfig viewConfig2 = ((ViewConfigDto)this.viewConfigRepository.save((Object)from)).toData();
        }
    }

    private SchedulingConfig generateSchedulingConfig(CacheSettings cacheSettings) {
        String strUnit;
        SchedulingConfig.SchedulingConfigBuilder builder = SchedulingConfig.builder().initialDelay(0L);
        int unitCount = cacheSettings.getRefreshFrequencyTimeUnitCount();
        switch (strUnit = cacheSettings.getRefreshFrequencyTimeUnit()) {
            case "month": {
                return builder.regularDelay((long)(unitCount * 30)).delayTimeUnit(TimeUnit.DAYS).build();
            }
            case "week": {
                return builder.regularDelay((long)(unitCount * 7)).delayTimeUnit(TimeUnit.DAYS).build();
            }
            case "day": {
                return builder.regularDelay((long)unitCount).delayTimeUnit(TimeUnit.DAYS).build();
            }
            case "hour": {
                return builder.regularDelay((long)unitCount).delayTimeUnit(TimeUnit.HOURS).build();
            }
            case "minute": {
                return builder.regularDelay((long)unitCount).delayTimeUnit(TimeUnit.MINUTES).build();
            }
            case "second": {
                return builder.regularDelay((long)unitCount).delayTimeUnit(TimeUnit.SECONDS).build();
            }
        }
        throw new IllegalStateException("Unit not supported : " + strUnit);
    }
}

