/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.trendz.security.entity.AuthToken;

public class SecurityUser {
    private AuthToken authToken;
    private String role;
    private String email;
    private Authority authority;
    private UUID tenantId;
    private UUID customerId;

    public Collection<GrantedAuthority> getAuthorities() {
        return Collections.singletonList(new SimpleGrantedAuthority(this.authority.name()));
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    public String getRole() {
        return this.role;
    }

    public String getEmail() {
        return this.email;
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public UUID getCustomerId() {
        return this.customerId;
    }

    public void setAuthToken(AuthToken authToken) {
        this.authToken = authToken;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityUser)) {
            return false;
        }
        SecurityUser other = (SecurityUser)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AuthToken this$authToken = this.getAuthToken();
        AuthToken other$authToken = other.getAuthToken();
        if (this$authToken == null ? other$authToken != null : !this$authToken.equals(other$authToken)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Authority this$authority = this.getAuthority();
        Authority other$authority = other.getAuthority();
        if (this$authority == null ? other$authority != null : !this$authority.equals(other$authority)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        return !(this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AuthToken $authToken = this.getAuthToken();
        result = result * 59 + ($authToken == null ? 43 : $authToken.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Authority $authority = this.getAuthority();
        result = result * 59 + ($authority == null ? 43 : $authority.hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        return result;
    }

    public String toString() {
        return "SecurityUser(authToken=" + this.getAuthToken() + ", role=" + this.getRole() + ", email=" + this.getEmail() + ", authority=" + this.getAuthority() + ", tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ")";
    }
}

