/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.security.TrendzErrorCode;
import org.thingsboard.trendz.security.TrendzErrorResponse;

@Component
public class TrendzErrorResponseHandler
implements AccessDeniedHandler,
AuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(TrendzErrorResponseHandler.class);
    private ObjectMapper mapper = new ObjectMapper();

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (!response.isCommitted()) {
            response.setContentType("application/json");
            response.setStatus(HttpStatus.FORBIDDEN.value());
            String message = "You don't have permission to perform this operation!";
            TrendzErrorResponse resp = TrendzErrorResponse.of((String)message, (TrendzErrorCode)TrendzErrorCode.PERMISSION_DENIED, (HttpStatus)HttpStatus.FORBIDDEN);
            this.mapper.writeValue((Writer)response.getWriter(), (Object)resp);
        }
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (!response.isCommitted()) {
            response.setContentType("application/json");
            response.setStatus(HttpStatus.FORBIDDEN.value());
            if (exception instanceof BadCredentialsException) {
                TrendzErrorResponse resp = TrendzErrorResponse.of((String)exception.getMessage(), (TrendzErrorCode)TrendzErrorCode.PERMISSION_DENIED, (HttpStatus)HttpStatus.FORBIDDEN);
                this.mapper.writeValue((Writer)response.getWriter(), (Object)resp);
                return;
            }
            String message = "You don't have permission to perform this operation!";
            TrendzErrorResponse resp = TrendzErrorResponse.of((String)message, (TrendzErrorCode)TrendzErrorCode.PERMISSION_DENIED, (HttpStatus)HttpStatus.FORBIDDEN);
            this.mapper.writeValue((Writer)response.getWriter(), (Object)resp);
        }
    }
}

