/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security;

import java.util.Date;
import org.springframework.http.HttpStatus;
import org.thingsboard.trendz.security.TrendzErrorCode;

public class TrendzErrorResponse {
    private final HttpStatus status;
    private final String message;
    private final TrendzErrorCode errorCode;
    private final Date timestamp;

    protected TrendzErrorResponse(String message, TrendzErrorCode errorCode, HttpStatus status) {
        this.message = message;
        this.errorCode = errorCode;
        this.status = status;
        this.timestamp = new Date();
    }

    public static TrendzErrorResponse of(String message, TrendzErrorCode errorCode, HttpStatus status) {
        return new TrendzErrorResponse(message, errorCode, status);
    }

    public Integer getStatus() {
        return this.status.value();
    }

    public String getMessage() {
        return this.message;
    }

    public TrendzErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }
}

