/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.Jwts;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.SecurityUser;

@Component
public class TokenExtractor {
    private static final Logger log = LoggerFactory.getLogger(TokenExtractor.class);
    public static final String propertyName = "jwt";

    public String extract(HttpServletRequest request) {
        String header = request.getHeader(propertyName);
        if (StringUtils.isBlank((CharSequence)header)) {
            return this.extractFromQuery(request);
        }
        return this.extractFromHeader(request);
    }

    private String extractFromHeader(HttpServletRequest request) {
        String token = request.getHeader(propertyName);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new AuthenticationServiceException("Authorization header cannot be blank!");
        }
        return token;
    }

    private String extractFromQuery(HttpServletRequest request) {
        String[] tokenParamValue;
        String token = null;
        if (request.getParameterMap() != null && !request.getParameterMap().isEmpty() && (tokenParamValue = (String[])request.getParameterMap().get(propertyName)) != null && tokenParamValue.length == 1) {
            token = tokenParamValue[0];
        }
        if (StringUtils.isBlank(token)) {
            throw new AuthenticationServiceException("Authorization query parameter cannot be blank!");
        }
        return token;
    }

    public SecurityUser parseAccessJwtToken(AuthToken authToken) {
        try {
            String customerId;
            String[] splitToken = authToken.getToken().split("\\.");
            String unsignedToken = splitToken[0] + "." + splitToken[1] + ".";
            Jwt jwtClaims = Jwts.parser().parseClaimsJwt(unsignedToken);
            Claims claims = (Claims)jwtClaims.getBody();
            String subject = claims.getSubject();
            List scopes = (List)claims.get("scopes", List.class);
            if (scopes == null || scopes.isEmpty()) {
                throw new IllegalArgumentException("JWT Token doesn't have any scopes");
            }
            SecurityUser securityUser = new SecurityUser();
            securityUser.setAuthToken(authToken);
            securityUser.setEmail(subject);
            securityUser.setAuthority(Authority.parse((String)((String)scopes.get(0))));
            String tenantId = (String)claims.get("tenantId", String.class);
            if (tenantId != null) {
                securityUser.setTenantId(UUID.fromString(tenantId));
            }
            if ((customerId = (String)claims.get("customerId", String.class)) != null) {
                securityUser.setCustomerId(UUID.fromString(customerId));
            }
            if (Authority.SYS_ADMIN.equals((Object)securityUser.getAuthority())) {
                throw new BadCredentialsException("Please use Tenant or Customer user credentials instead of System Administrator");
            }
            return securityUser;
        }
        catch (ExpiredJwtException ex) {
            throw new BadCredentialsException("Token expired");
        }
    }

    public JwtSecUser getJwtSecUser(String rawToken) {
        try {
            String[] splitToken = rawToken.split("\\.");
            String unsignedToken = splitToken[0] + "." + splitToken[1] + ".";
            Claims body = (Claims)Jwts.parser().parseClaimsJwt(unsignedToken).getBody();
            String tenantIdRaw = (String)body.get("tenantId", String.class);
            String customerIdRaw = (String)body.get("customerId", String.class);
            String userIdRaw = (String)body.get("userId", String.class);
            JwtSecUser secUser = new JwtSecUser();
            secUser.setTenantId(StringUtils.isNotBlank((CharSequence)tenantIdRaw) ? UUID.fromString(tenantIdRaw) : EntityId.NULL_UUID);
            secUser.setCustomerId(StringUtils.isNotBlank((CharSequence)customerIdRaw) ? UUID.fromString(customerIdRaw) : EntityId.NULL_UUID);
            secUser.setUserId(StringUtils.isNotBlank((CharSequence)userIdRaw) ? UUID.fromString(userIdRaw) : EntityId.NULL_UUID);
            return secUser;
        }
        catch (Exception ex) {
            log.error("Invalid JWT Token", (Throwable)ex);
            throw new BadCredentialsException("Invalid JWT token: ", (Throwable)ex);
        }
    }
}

