/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.security.entity.SecurityUser;

@Component
public class RestAwareAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final ObjectMapper mapper = new ObjectMapper();

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        SecurityUser securityUser = (SecurityUser)authentication.getPrincipal();
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        mapper.writeValue((Writer)response.getWriter(), (Object)securityUser.getAuthToken());
        this.clearAuthenticationAttributes(request);
    }

    protected final void clearAuthenticationAttributes(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("SPRING_SECURITY_LAST_EXCEPTION");
    }
}

