/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.thingsboard.trendz.security.TokenExtractor;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.RefreshAuthenticationToken;
import org.thingsboard.trendz.security.entity.SecurityUser;
import org.thingsboard.trendz.service.provider.TbRestDataSource;

@Component
public class RefreshTokenAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    private TokenExtractor tokenExtractor;
    @Autowired
    private TbRestDataSource tbApi;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            Assert.notNull((Object)authentication, (String)"No authentication data provided");
            AuthToken credentials = (AuthToken)authentication.getCredentials();
            AuthToken authToken = this.tbApi.refreshToken(credentials.getRefreshToken());
            SecurityUser securityUser = this.tokenExtractor.parseAccessJwtToken(authToken);
            return new RefreshAuthenticationToken(securityUser);
        }
        catch (Throwable th) {
            throw new BadCredentialsException("Could not refresh token", th);
        }
    }

    public boolean supports(Class<?> authentication) {
        return RefreshAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

