/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.security.TokenExtractor;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.JwtAuthenticationToken;
import org.thingsboard.trendz.security.entity.SecurityUser;

@Component
public class JwtAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    private TokenExtractor tokenExtractor;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AuthToken authToken = (AuthToken)authentication.getCredentials();
        SecurityUser securityUser = this.tokenExtractor.parseAccessJwtToken(authToken);
        return new JwtAuthenticationToken(securityUser);
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

