/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.security.TokenExtractor;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.service.provider.TbRestDataSource;

@Service
public class AuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationService.class);
    @Value(value="${authentication.login}")
    private String adminLogin;
    @Value(value="${authentication.password}")
    private String adminPassword;
    @Autowired
    private TbRestDataSource tbApi;
    @Autowired
    private TokenExtractor tokenExtractor;
    private AuthToken authToken;

    @PostConstruct
    @Scheduled(cron="0 0 * * * *", zone="Europe/Kiev")
    public void updateToken() {
        try {
            this.authToken = this.tbApi.login(this.adminLogin, this.adminPassword);
        }
        catch (Exception e) {
            this.authToken = null;
            log.error("Authentication Service can't update token.");
        }
    }

    public String getJwtToken() {
        if (this.authToken == null) {
            this.updateToken();
            if (this.authToken == null) {
                throw new IllegalStateException("AuthToken is not defined.");
            }
        }
        return this.authToken.getToken();
    }

    public TenantId getTenantId() {
        String jwtToken = this.getJwtToken();
        JwtSecUser secUser = this.tokenExtractor.getJwtSecUser(jwtToken);
        return new TenantId(secUser.getTenantId());
    }
}

