/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.ml.AnomalyService;
import org.thingsboard.trendz.ml.ClusterTaskCache;
import org.thingsboard.trendz.ml.MLService;
import org.thingsboard.trendz.ml.ModelService;
import org.thingsboard.trendz.ml.anomaly.AnomalyFilter;
import org.thingsboard.trendz.ml.anomaly.AnomalyJoiner;
import org.thingsboard.trendz.ml.anomaly.AnomalyScoreTuner;
import org.thingsboard.trendz.ml.domain.ClusterModel;
import org.thingsboard.trendz.ml.domain.DatasetConfig;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.ModelProperties;
import org.thingsboard.trendz.ml.domain.ModelType;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.task.Task;
import org.thingsboard.trendz.task.TaskService;
import org.thingsboard.trendz.task.TaskStatus;

@Component
public class ClusterTool {
    private static final Logger log = LoggerFactory.getLogger(ClusterTool.class);
    @Autowired
    private MLService mlService;
    @Autowired
    private ClusterTaskCache clusterTaskCache;
    @Autowired
    private AnomalyJoiner anomalyJoiner;
    @Autowired
    private AnomalyScoreTuner anomalyScoreTuner;
    @Autowired
    private ModelService modelService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private AnomalyService anomalyService;
    @Autowired
    private BusinessEntityService entityService;

    public void onApplicationEvent(ApplicationReadyEvent event) {
    }

    public ModelProperties buildDefProperties(TenantId tenantId) {
        List entities = this.entityService.getAllEntities(tenantId);
        Optional<BusinessEntity> first = entities.stream().filter(e -> e.getFields().stream().anyMatch(f -> f.getQuery().getQueryType() == FieldQueryType.TELEMETRY)).findFirst();
        BusinessEntity businessEntity = first.orElse((BusinessEntity)entities.iterator().next());
        UUID tsFieldId = businessEntity.getFields().stream().filter(f -> f.getQuery().getQueryType() == FieldQueryType.TELEMETRY).findFirst().get().getId();
        UUID itemNameFieldId = businessEntity.getFields().stream().filter(f -> f.getQuery().getQueryType() == FieldQueryType.ENTITY_NAME).findFirst().get().getId();
        UUID businessEntityId = businessEntity.getId();
        DatasetConfig dsConfig = new DatasetConfig();
        dsConfig.setTenantId(tenantId);
        dsConfig.setJwtToken("eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJidWlsZGluZ0B0aGluZ3Nib2FyZC5vcmciLCJzY29wZXMiOlsiVEVOQU5UX0FETUlOIl0sInVzZXJJZCI6IjRkYjljYmMwLWZjYmEtMTFlYS1hYjZiLTk5OTVmYWE2OThmNyIsImVuYWJsZWQiOnRydWUsImlzUHVibGljIjpmYWxzZSwidGVuYW50SWQiOiI0NDMwM2NiMC1mY2JhLTExZWEtYWI2Yi05OTk1ZmFhNjk4ZjciLCJjdXN0b21lcklkIjoiMTM4MTQwMDAtMWRkMi0xMWIyLTgwODAtODA4MDgwODA4MDgwIiwiaXNzIjoidGhpbmdzYm9hcmQuaW8iLCJpYXQiOjE2MDk5MzQ4MDAsImV4cCI6MTYxODkzNDgwMH0.iODML4vLR2q__1ZiTt2y4tjaS0hARUp4JQRxwGB7PgGjUBf5ZJOw_Me9WQYjwzqQnEwH7Wr2I7WpncIT78fVsg");
        dsConfig.setStartTs(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(180L));
        dsConfig.setEndTs(System.currentTimeMillis());
        ViewField itemFilterField = new ViewField();
        itemFilterField.setAggregationType(FieldAggregation.UNIQ);
        itemFilterField.setBusinessEntityId(businessEntityId);
        itemFilterField.setEntityFieldId(itemNameFieldId);
        itemFilterField.setId(TimeStampUUIDGenerator.generateId());
        itemFilterField.setHidden(true);
        ViewField analyzeField = new ViewField();
        analyzeField.setAggregationType(FieldAggregation.AVG);
        analyzeField.setBusinessEntityId(businessEntityId);
        analyzeField.setEntityFieldId(tsFieldId);
        analyzeField.setId(TimeStampUUIDGenerator.generateId());
        RuntimeFilterField rff = new RuntimeFilterField();
        rff.setCondition(FilterCondition.ONE_OF);
        rff.setViewFieldId(itemFilterField.getId());
        rff.setSelection((Set)Sets.newHashSet());
        dsConfig.setRuntimeFilters((List)Lists.newArrayList((Object[])new RuntimeFilterField[]{rff}));
        dsConfig.setHiddenFields((List)Lists.newArrayList((Object[])new ViewField[]{itemFilterField}));
        ModelProperties props = new ModelProperties();
        props.setName("My model _ " + new Date());
        props.setModelType(ModelType.CLUSTERING);
        props.setDatasetConfig(dsConfig);
        props.setMlProperties(MlProperties.defaultProps());
        return props;
    }

    private void runTestModel() {
        long start = System.currentTimeMillis();
        TenantId tenantId = new TenantId(UUID.fromString("44303cb0-fcba-11ea-ab6b-9995faa698f7"));
        ModelProperties props = this.buildDefProperties(tenantId);
        log.info("Submit model");
        Task task = this.modelService.buildModelAsync(props);
        UUID modelId = task.getModelId();
        log.info("model submitted. Wait for finish");
        Task asyncTask = this.taskService.getTask(task.getId());
        while (!asyncTask.getStatus().equals((Object)TaskStatus.READY) && !asyncTask.getStatus().equals((Object)TaskStatus.CANCELED)) {
            log.info("Wait for finish {}", (Object)asyncTask);
            asyncTask = this.taskService.getTask(task.getId());
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println();
        System.out.println();
        System.out.println();
        log.info("Task finished: {}", (Object)asyncTask.getStatus());
        ClusterModel model = (ClusterModel)this.modelService.getModelById(modelId);
        log.info("Model status {} clusters {}", (Object)model.getStatus(), (Object)model.getClusters().size());
        log.info("compleated in {} MS", (Object)(System.currentTimeMillis() - start));
        System.out.println();
        System.out.println();
        AnomalyFilter anomalyFilter = new AnomalyFilter();
        anomalyFilter.setModelIds((Set)Sets.newHashSet((Object[])new UUID[]{modelId}));
        List anomalies = this.anomalyService.getAnomalies(anomalyFilter);
        log.info("Found {} anomalies. max score {}", (Object)anomalies.size(), (Object)anomalies.stream().mapToDouble(a -> a.getScore()).max().orElse(-1.0));
        List modelTasks = this.taskService.findAnomalyTasksForModel(modelId);
        log.info("Found {} model Tasks", (Object)modelTasks.size());
        for (Task modelTask : modelTasks) {
            AnomalyFilter af = new AnomalyFilter();
            af.setModelIds((Set)Sets.newHashSet((Object[])new UUID[]{modelId}));
            af.setTaskIds((Set)Sets.newHashSet((Object[])new UUID[]{modelTask.getId()}));
            List taskAnomalies = this.anomalyService.getAnomalies(af);
            log.info("Task has {} anomalies", (Object)taskAnomalies.size());
        }
        this.applyModelToNewItems(props.getDatasetConfig(), modelId);
    }

    private void applyModelToNewItems(DatasetConfig dsConfig, UUID modelId) {
        ((RuntimeFilterField)dsConfig.getRuntimeFilters().iterator().next()).setSelection((Set)Sets.newHashSet());
        Task task = this.anomalyService.discoverAnomaliesAsync(modelId, dsConfig);
        Task asyncTask = this.taskService.getTask(task.getId());
        while (!asyncTask.getStatus().equals((Object)TaskStatus.READY) && !asyncTask.getStatus().equals((Object)TaskStatus.CANCELED)) {
            log.info("Wait for apply model finish {}", (Object)asyncTask);
            asyncTask = this.taskService.getTask(task.getId());
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.info("apply model Task finished: {} {}", (Object)asyncTask.getStatus(), (Object)task.getId());
        List modelTasks = this.taskService.findAnomalyTasksForModel(modelId);
        log.info("Found {} model Tasks", (Object)modelTasks.size());
        for (Task modelTask : modelTasks) {
            AnomalyFilter af = new AnomalyFilter();
            af.setModelIds((Set)Sets.newHashSet((Object[])new UUID[]{modelId}));
            af.setTaskIds((Set)Sets.newHashSet((Object[])new UUID[]{modelTask.getId()}));
            List taskAnomalies = this.anomalyService.getAnomalies(af);
            log.info("Task {} has {} anomalies. MaxScore {}", new Object[]{modelTask.getId(), taskAnomalies.size(), taskAnomalies.stream().mapToDouble(a -> a.getScore()).max().orElse(-1.0)});
        }
    }
}

