/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.ml.domain.Anomaly;
import org.thingsboard.trendz.ml.domain.ScoredPoint;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnomalyFileDumper {
    private static final Logger log = LoggerFactory.getLogger(AnomalyFileDumper.class);
    private static long goodSamples = 1L;
    private static long strangeSamples = 5L;

    public static void dump(List<Anomaly> anomalies) {
        ArrayList collect = Lists.newArrayList();
        for (Long clId : anomalies.stream().map(Anomaly::getClusterId).collect(Collectors.toSet())) {
            anomalies.sort(Comparator.comparingDouble(Anomaly::getScore));
            collect.addAll(anomalies.stream().filter(a -> a.getClusterId() == clId.longValue()).limit(goodSamples).collect(Collectors.toList()));
            anomalies.sort(Comparator.comparingDouble(Anomaly::getScore).reversed());
            collect.addAll(anomalies.stream().filter(a -> a.getClusterId() == clId.longValue()).limit(strangeSamples).collect(Collectors.toList()));
        }
        for (Anomaly anomaly : anomalies) {
            ArrayList raw = Lists.newArrayList();
            for (ScoredPoint point : anomaly.getData()) {
                long hour = LocalDateTime.ofEpochSecond(point.getT() / 1000L, 0, ZoneOffset.UTC).getHour();
                raw.add(Lists.newArrayList((Object[])new Long[]{point.getT(), hour, point.getS().longValue()}));
            }
            System.out.println();
            try {
                System.out.println(new ObjectMapper().writeValueAsString((Object)raw));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            System.out.println();
        }
        collect = Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)collect));
        collect.forEach(a -> AnomalyFileDumper.fillGaps((List)a.getData()));
        try {
            String str = new ObjectMapper().writeValueAsString((Object)collect);
            FileUtils.write((File)new File("/home/vitaliy/projects/trendz_copy/ui/src/assets/data-ext.json"), (CharSequence)str, (Charset)Charset.defaultCharset());
            log.info("Dumped {} anomalies. Size {} chars", (Object)collect.size(), (Object)(str.length() / 1000000));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void fillGaps(List<ScoredPoint> records) {
    }
}

