/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.segment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.domain.ComplexTsPoint;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.Segment;
import org.thingsboard.trendz.ml.segment.SegmentSplitter;

@Component
public class SlidingWindowSegmentSplitter
implements SegmentSplitter {
    private static final Logger log = LoggerFactory.getLogger(SlidingWindowSegmentSplitter.class);

    public List<Segment> split(List<ComplexTsPoint> points, MlProperties.SegmentSplitProperties properties) {
        int slidingStepPercent = properties.getSlidingStepPercent();
        long windowTimeMs = properties.getWindowSizeMs();
        long maxGapMs = properties.getMaxGapMs();
        ArrayList result = Lists.newArrayList();
        LinkedList<ComplexTsPoint> window = new LinkedList<ComplexTsPoint>();
        long slidingStepMs = windowTimeMs * (long)slidingStepPercent / 100L;
        int currIndex = 0;
        window.add(points.get(currIndex));
        ++currIndex;
        while (currIndex < points.size()) {
            Segment segment;
            ComplexTsPoint currRecord = points.get(currIndex);
            long possibleDuration = currRecord.getTs() - ((ComplexTsPoint)window.getFirst()).getTs();
            long gap = currRecord.getTs() - ((ComplexTsPoint)window.getLast()).getTs();
            if (gap > maxGapMs) {
                segment = this.buildSegment(window);
                result.add(segment);
                window.clear();
            } else if (possibleDuration > windowTimeMs) {
                segment = this.buildSegment(window);
                result.add(segment);
                long slidingStartTs = ((ComplexTsPoint)window.getFirst()).getTs();
                while (!window.isEmpty() && currRecord.getTs() - ((ComplexTsPoint)window.getFirst()).getTs() > windowTimeMs) {
                    window.pollFirst();
                }
                while (!window.isEmpty() && ((ComplexTsPoint)window.getFirst()).getTs() - slidingStartTs < slidingStepMs) {
                    window.pollFirst();
                }
            }
            window.add(currRecord);
            ++currIndex;
        }
        return result;
    }

    private Segment buildSegment(List<ComplexTsPoint> points) {
        Segment segment = new Segment();
        segment.setRecords((List)Lists.newArrayList(points));
        segment.setMinTs(points.stream().mapToLong(ComplexTsPoint::getTs).min().orElse(Long.MIN_VALUE));
        segment.setMaxTs(points.stream().mapToLong(ComplexTsPoint::getTs).max().orElse(Long.MAX_VALUE));
        return segment;
    }
}

