/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.segment;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.Segment;

@Component
public class SegmentFilterer {
    private static final Logger log = LoggerFactory.getLogger(SegmentFilterer.class);

    public List<Segment> filter(List<Segment> original, MlProperties.SegmentFilterProperties properties) {
        List<Segment> collect = original.stream().filter(s -> this.validateSize(s, properties.getMinSize())).filter(s -> this.validateDuration(s, properties.getMinDurationMs())).collect(Collectors.toList());
        log.info("Segments after filtering {}. Cleared {}", (Object)collect.size(), (Object)(original.size() - collect.size()));
        return collect;
    }

    private boolean validateSize(Segment segment, int minSize) {
        return segment.getRecords().size() >= minSize;
    }

    private boolean validateDuration(Segment segment, long minDuration) {
        return segment.getMaxTs() - segment.getMinTs() >= minDuration;
    }
}

