/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.segment;

import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.domain.SimpleTsPoint;

@Component
public class LRReducer {
    private static final Logger log = LoggerFactory.getLogger(LRReducer.class);

    public List<SimpleTsPoint> reduceSegmentDimension(List<SimpleTsPoint> original) {
        double maxError = this.getMaxError(original);
        ArrayList reduced = Lists.newArrayList();
        reduced.add(original.get(0));
        SimpleTsPoint record = original.get(0);
        SimpleRegression sr = new SimpleRegression();
        sr.addData((double)record.getTs(), record.getValue());
        SimpleTsPoint prevRec = record;
        for (int currIndex = 0; currIndex < original.size(); ++currIndex) {
            record = original.get(currIndex);
            sr.addData((double)record.getTs(), record.getValue());
            double error = sr.getSumSquaredErrors();
            if (error > maxError) {
                reduced.add(prevRec);
                sr = new SimpleRegression();
                sr.addData((double)record.getTs(), record.getValue());
            }
            prevRec = record;
        }
        reduced.add(prevRec);
        log.debug("Reduce from {} to {}", (Object)original.size(), (Object)reduced.size());
        return reduced;
    }

    private double getMaxError(List<SimpleTsPoint> original) {
        StandardDeviation sd2 = new StandardDeviation();
        return sd2.evaluate(Doubles.toArray((Collection)original.stream().map(SimpleTsPoint::getValue).collect(Collectors.toList()))) / 10.0;
    }
}

