/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.segment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.domain.ComplexTsPoint;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.Segment;
import org.thingsboard.trendz.ml.segment.SegmentSplitter;

@Component
public class FixedRangeSegmentSplitter
implements SegmentSplitter {
    public List<Segment> split(List<ComplexTsPoint> points, MlProperties.SegmentSplitProperties properties) {
        ArrayList segmentPoints;
        long windowTimeMs = properties.getWindowSizeMs();
        long maxGapMs = properties.getMaxGapMs();
        ArrayList segments = Lists.newArrayList();
        for (int startIndex = 0; startIndex < points.size(); startIndex += segmentPoints.size()) {
            long duration;
            ComplexTsPoint record = points.get(startIndex);
            long segmentStartTs = record.getTs();
            segmentPoints = Lists.newArrayList();
            segmentPoints.add(record);
            ComplexTsPoint prevRec = record;
            for (int currIndex = startIndex + 1; currIndex < points.size() && (duration = (record = points.get(currIndex)).getTs() - segmentStartTs) <= windowTimeMs && record.getTs() - prevRec.getTs() <= maxGapMs; ++currIndex) {
                segmentPoints.add(record);
                prevRec = record;
            }
            segments.add(this.buildSegment((List)segmentPoints));
        }
        return segments;
    }

    private Segment buildSegment(List<ComplexTsPoint> points) {
        Segment segment = new Segment();
        segment.setRecords((List)Lists.newArrayList(points));
        segment.setMinTs(points.stream().mapToLong(ComplexTsPoint::getTs).min().orElse(Long.MIN_VALUE));
        segment.setMaxTs(points.stream().mapToLong(ComplexTsPoint::getTs).max().orElse(Long.MAX_VALUE));
        return segment;
    }
}

