/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.segment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.domain.ComplexTsPoint;
import org.thingsboard.trendz.ml.domain.SimpleTsPoint;

@Component
public class DataVectorTransformer {
    private static final Logger log = LoggerFactory.getLogger(DataVectorTransformer.class);

    public List<ComplexTsPoint> toComplexPoints(Map<UUID, List<SimpleTsPoint>> allPoints) {
        ArrayList complexPoints = Lists.newArrayList();
        HashMap<UUID, Map> hashedPoints = new HashMap<UUID, Map>();
        for (Map.Entry<UUID, List<SimpleTsPoint>> entry : allPoints.entrySet()) {
            Map map = hashedPoints.computeIfAbsent(entry.getKey(), i -> new HashMap());
            entry.getValue().forEach(p -> map.put(p.getTs(), p));
        }
        Set allTs = allPoints.values().stream().flatMap(Collection::stream).map(SimpleTsPoint::getTs).collect(Collectors.toCollection(TreeSet::new));
        for (Long ts : allTs) {
            HashMap values = new HashMap();
            for (Map.Entry entry : hashedPoints.entrySet()) {
                SimpleTsPoint simpleTsPoint = (SimpleTsPoint)((Map)entry.getValue()).get(ts);
                if (simpleTsPoint != null) {
                    values.put(entry.getKey(), simpleTsPoint.getValue());
                    continue;
                }
                values.put(entry.getKey(), null);
            }
            ComplexTsPoint complexTsPoint = new ComplexTsPoint();
            complexTsPoint.setTs(ts.longValue());
            complexTsPoint.setValues(values);
            complexPoints.add(complexTsPoint);
        }
        complexPoints.sort(Comparator.comparingLong(ComplexTsPoint::getTs));
        return complexPoints;
    }
}

