/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.segment;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.domain.ComplexTsPoint;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.Segment;
import org.thingsboard.trendz.ml.segment.FixedRangeSegmentSplitter;
import org.thingsboard.trendz.ml.segment.SegmentSplitter;
import org.thingsboard.trendz.ml.segment.SlidingWindowSegmentSplitter;

@Component
public class CompositSegmentSplitter
implements SegmentSplitter {
    private static final Logger log = LoggerFactory.getLogger(CompositSegmentSplitter.class);
    @Autowired
    private FixedRangeSegmentSplitter fixedRangeSegmentSplitter;
    @Autowired
    private SlidingWindowSegmentSplitter slidingWindowSegmentSplitter;

    public List<Segment> split(List<ComplexTsPoint> points, MlProperties.SegmentSplitProperties properties) {
        if (CollectionUtils.isEmpty(points)) {
            return Collections.emptyList();
        }
        SegmentSplitter splitter = this.getSplitter(properties);
        List segments = splitter.split(points, properties);
        log.info("Found segments {}", (Object)segments.size());
        return segments;
    }

    private SegmentSplitter getSplitter(MlProperties.SegmentSplitProperties properties) {
        if (MlProperties.SegmentSplitType.FIXED_TIME.equals((Object)properties.getType())) {
            return this.fixedRangeSegmentSplitter;
        }
        if (MlProperties.SegmentSplitType.SLIDING_WINDOW.equals((Object)properties.getType())) {
            return this.slidingWindowSegmentSplitter;
        }
        throw new IllegalStateException("Segment split algorithm not supported " + properties.getType());
    }
}

