/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.segment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.DoubleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.domain.ComplexTsPoint;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.segment.AggregateReducer;

@Component
public class AggregateReducer {
    private static final Logger log = LoggerFactory.getLogger(AggregateReducer.class);

    public List<ComplexTsPoint> reduce(List<ComplexTsPoint> original, Set<UUID> fieldIds, int requiredSize, MlProperties.FeatureAggregation aggregation) {
        ArrayList aggregated = Lists.newArrayList();
        long maxTs = original.stream().mapToLong(ComplexTsPoint::getTs).max().orElse(0L);
        long minTs = original.stream().mapToLong(ComplexTsPoint::getTs).min().orElse(0L);
        long stepMs = (maxTs - minTs) / (long)requiredSize;
        for (long windowStartTs = minTs; windowStartTs <= maxTs; windowStartTs += stepMs) {
            long finalWindowStartTs = windowStartTs;
            HashMap<UUID, Double> valueMap = new HashMap<UUID, Double>();
            for (UUID fieldId : fieldIds) {
                DoubleStream doubleStream = original.stream().filter(r -> r.getTs() >= finalWindowStartTs && r.getTs() <= finalWindowStartTs + stepMs).mapToDouble(cp -> (Double)cp.getValues().get(fieldId));
                double aggValue = this.aggregate(doubleStream, aggregation);
                valueMap.put(fieldId, aggValue);
            }
            ComplexTsPoint aggRec = new ComplexTsPoint(windowStartTs, valueMap);
            aggregated.add(aggRec);
        }
        return aggregated;
    }

    private double aggregate(DoubleStream doubleStream, MlProperties.FeatureAggregation agg) {
        switch (1.$SwitchMap$org$thingsboard$trendz$ml$domain$MlProperties$FeatureAggregation[agg.ordinal()]) {
            case 1: {
                return doubleStream.sum();
            }
            case 2: {
                return doubleStream.average().orElse(0.0);
            }
            case 3: {
                return doubleStream.min().orElse(0.0);
            }
            case 4: {
                return doubleStream.max().orElse(0.0);
            }
            case 5: {
                return doubleStream.count();
            }
        }
        throw new IllegalStateException("Aggregation not supported: " + agg);
    }
}

