/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.fetcher;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.TbBusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.TbBusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.DataRow;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.runtime.ViewTask;
import org.thingsboard.trendz.ml.domain.DataVector;
import org.thingsboard.trendz.ml.domain.DatasetConfig;
import org.thingsboard.trendz.ml.domain.SimpleTsPoint;
import org.thingsboard.trendz.ml.fetcher.DatasetFetcher;
import org.thingsboard.trendz.ml.fetcher.DatasetIterator;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ViewService;
import org.thingsboard.trendz.service.view.ViewTaskCache;
import reactor.core.publisher.Mono;

@Component
public class DirectDatasetFetcher
implements DatasetFetcher {
    private static final Logger log = LoggerFactory.getLogger(DirectDatasetFetcher.class);
    private static UUID tsFieldId = TimeStampUUIDGenerator.generateId();
    @Autowired
    private BusinessEntityService businessEntityService;
    @Autowired
    private ViewService viewService;
    @Autowired
    private ViewTaskCache viewTaskCache;
    @Autowired
    private TbRestDataSource dataSource;
    private Map<UUID, AtomicLong> taskLoadedPointsMap = new ConcurrentHashMap();
    private Map<UUID, AtomicLong> taskLoadedItemsMap = new ConcurrentHashMap();

    public List<DataVector> fetchItemFieldFromDataset(DatasetConfig originalDataset, UUID viewFieldId, String itemName) {
        Optional<ViewField> optionalField = originalDataset.getFields().stream().filter(f -> f.getId().equals(viewFieldId)).findFirst();
        if (!optionalField.isPresent()) {
            throw new IllegalStateException("field Id not valid");
        }
        ViewField field = optionalField.get();
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(originalDataset.getTenantId(), field.getBusinessEntityId());
        BusinessEntityField entityNameField = businessEntity.getFields().stream().filter(f -> FieldQueryType.ENTITY_NAME.equals((Object)f.getQuery().getQueryType())).findFirst().get();
        Optional<ViewField> nameFilterOpt = originalDataset.getHiddenFields().stream().filter(f -> f.getEntityFieldId().equals(entityNameField.getId())).findFirst();
        if (nameFilterOpt.isPresent()) {
            ViewField itemFilterField = nameFilterOpt.get();
            RuntimeFilterField rff = originalDataset.getRuntimeFilters().stream().filter(f -> itemFilterField.getId().equals(f.getViewFieldId())).findFirst().get();
            rff.setSelection((Set)Sets.newHashSet((Object[])new String[]{itemName}));
            rff.setCondition(FilterCondition.ONE_OF);
        } else {
            ViewField itemFilterField = new ViewField();
            itemFilterField.setAggregationType(FieldAggregation.UNIQ);
            itemFilterField.setBusinessEntityId(businessEntity.getId());
            itemFilterField.setEntityFieldId(entityNameField.getId());
            itemFilterField.setId(TimeStampUUIDGenerator.generateId());
            itemFilterField.setHidden(true);
            RuntimeFilterField rff = new RuntimeFilterField();
            rff.setCondition(FilterCondition.ONE_OF);
            rff.setViewFieldId(itemFilterField.getId());
            rff.setSelection((Set)Sets.newHashSet((Object[])new String[]{itemName}));
            originalDataset.getHiddenFields().add(itemFilterField);
            originalDataset.getRuntimeFilters().add(rff);
        }
        return this.fetchDataset(originalDataset);
    }

    public List<DataVector> fetchDataset(DatasetConfig datasetConfig) {
        UUID fetchTaskId = this.initCounters();
        Set items = this.loadItems(datasetConfig);
        log.info("Found {} items", (Object)items.size());
        List dataVectors = this.loadValues(items, datasetConfig, fetchTaskId);
        long totalPoints = dataVectors.stream().mapToLong(dv -> dv.getPoints().values().stream().mapToLong(List::size).sum()).sum();
        log.info("Total {} points loaded for {} items / from {}", new Object[]{totalPoints, dataVectors.size(), items.size()});
        return dataVectors;
    }

    public DatasetIterator getDatasetIterator(DatasetConfig datasetConfig) {
        UUID fetchTaskId = this.initCounters();
        Set items = this.loadItems(datasetConfig);
        DatasetIterator iterator = new DatasetIterator(items, item -> this.loadValues(Collections.singleton(item), datasetConfig, fetchTaskId));
        return iterator;
    }

    private UUID initCounters() {
        UUID fetchTaskId = TimeStampUUIDGenerator.generateId();
        this.taskLoadedItemsMap.put(fetchTaskId, new AtomicLong());
        this.taskLoadedPointsMap.put(fetchTaskId, new AtomicLong());
        return fetchTaskId;
    }

    private Set<Item> loadItems(DatasetConfig datasetConfig) {
        ViewConfig viewConfig = this.buildViewConfigForItems(datasetConfig);
        List dataRows = this.loadDataRowsForViewConfig(viewConfig, datasetConfig);
        List dataVectors = this.mapRows(dataRows, datasetConfig);
        Set<Item> items = dataVectors.stream().map(dv -> {
            Item item = new Item(dv.getItemId(), null, null, dv.getItemName(), null);
            return item;
        }).collect(Collectors.toSet());
        return items;
    }

    private List<DataVector> loadValues(Set<Item> items, DatasetConfig datasetConfig, UUID fetchTaskId) {
        Set businessEntityIds = datasetConfig.getFields().stream().map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
        if (businessEntityIds.size() != 1) {
            throw new IllegalStateException("Fields from multiple Business Entities are not supported");
        }
        UUID businessEntityId = (UUID)businessEntityIds.iterator().next();
        BusinessEntity entity = this.businessEntityService.findEntityById(datasetConfig.getTenantId(), businessEntityId);
        HashMap fieldMap = new HashMap();
        datasetConfig.getFields().forEach(vf -> {
            BusinessEntityField entityField = entity.getFields().stream().filter(bef -> bef.getId().equals(vf.getEntityFieldId())).findFirst().get();
            if (FieldQueryType.TELEMETRY.equals((Object)entityField.getQuery().getQueryType())) {
                fieldMap.put(vf, entityField);
            }
        });
        String entityType = ((TbBusinessEntityQuery)entity.getQuery()).getEntityType().toString();
        ArrayList dataVectors = Lists.newArrayList();
        for (Item item : items) {
            long loadedPointsCnt;
            Map itemValues = this.loadItemValues(item, entityType, fieldMap, datasetConfig, fetchTaskId);
            DataVector dv = new DataVector();
            dv.setItemId(item.getId());
            dv.setItemName(item.getName());
            dv.setPoints(itemValues);
            dataVectors.add(dv);
            int maxPointsCount = datasetConfig.getMaxPointsCount();
            if (maxPointsCount <= 0) {
                maxPointsCount = 1000000;
            }
            if ((loadedPointsCnt = ((AtomicLong)this.taskLoadedPointsMap.get(fetchTaskId)).get()) > (long)maxPointsCount) {
                log.info("dataset max points threshold reached. Stop loading {} / {}", (Object)maxPointsCount, (Object)loadedPointsCnt);
                break;
            }
            ((AtomicLong)this.taskLoadedItemsMap.get(fetchTaskId)).incrementAndGet();
        }
        return dataVectors;
    }

    private Map<UUID, List<SimpleTsPoint>> loadItemValues(Item item, String entityType, Map<ViewField, BusinessEntityField> fieldMap, DatasetConfig datasetConfig, UUID fetchTaskId) {
        ConcurrentHashMap<UUID, List<SimpleTsPoint>> values = new ConcurrentHashMap<UUID, List<SimpleTsPoint>>();
        for (ViewField viewField : fieldMap.keySet()) {
            BusinessEntityField entityField = fieldMap.get(viewField);
            String key = ((TbBusinessEntityFieldQuery)entityField.getQuery()).getKey();
            List points = this.pageableTelemetryLoad(item, entityType, key, datasetConfig, fetchTaskId);
            values.put(viewField.getId(), points);
        }
        return values;
    }

    private List<SimpleTsPoint> pageableTelemetryLoad(Item item, String entityType, String key, DatasetConfig datasetConfig, UUID fetchTaskId) {
        int pageSize = 100000;
        boolean procceedLoad = true;
        ArrayList allPoints = Lists.newArrayList();
        long startTs = datasetConfig.getStartTs();
        long endTs = datasetConfig.getEndTs();
        while (procceedLoad) {
            Mono fieldValuesMono = this.dataSource.loadTelemetry(entityType, item.getId(), key, startTs, endTs, 0L, "NONE", pageSize, datasetConfig.getJwtToken());
            int resultSize = 0;
            Map fieldValues = (Map)fieldValuesMono.block();
            for (String fieldId : fieldValues.keySet()) {
                if (!fieldId.equals(key)) continue;
                List pageData = ((List)fieldValues.get(fieldId)).stream().map(tsData -> new SimpleTsPoint(tsData.getTs(), Double.parseDouble(tsData.getValue()))).sorted(Comparator.comparingLong(SimpleTsPoint::getTs)).collect(Collectors.toList());
                allPoints.addAll(pageData);
                AtomicLong pointsCounter = (AtomicLong)this.taskLoadedPointsMap.get(fetchTaskId);
                AtomicLong itemsCounter = (AtomicLong)this.taskLoadedItemsMap.get(fetchTaskId);
                pointsCounter.addAndGet(pageData.size());
                log.info("Page data loaded {}. Total size {} Items {}", new Object[]{pageData.size(), pointsCounter.get(), itemsCounter.get()});
                int maxPointsCount = datasetConfig.getMaxPointsCount();
                if (maxPointsCount <= 0) {
                    maxPointsCount = 1000000;
                }
                if (pointsCounter.get() > (long)maxPointsCount) {
                    procceedLoad = false;
                    break;
                }
                long minTs = pageData.stream().mapToLong(p -> p.getTs()).min().orElse(0L);
                long maxTs = pageData.stream().mapToLong(p -> p.getTs()).max().orElse(0L);
                endTs = minTs;
                resultSize = pageData.size();
            }
            if (resultSize == pageSize) continue;
            procceedLoad = false;
        }
        return allPoints;
    }

    private ViewConfig buildViewConfigForItems(DatasetConfig datasetConfig) {
        Set businessEntityIds = datasetConfig.getFields().stream().map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
        if (businessEntityIds.size() != 1) {
            throw new IllegalStateException("Fields from multiple Business Entities are not supported");
        }
        UUID businessEntityId = (UUID)businessEntityIds.iterator().next();
        BusinessEntity entity = this.businessEntityService.findEntityById(datasetConfig.getTenantId(), businessEntityId);
        BusinessEntityField entityNameField = entity.getFields().stream().filter(f -> f.getQuery().getQueryType().equals((Object)FieldQueryType.ENTITY_NAME)).findFirst().get();
        ViewField itemNameField = new ViewField();
        itemNameField.setAggregationType(FieldAggregation.UNIQ);
        itemNameField.setBusinessEntityId(entity.getId());
        itemNameField.setEntityFieldId(entityNameField.getId());
        itemNameField.setId(TimeStampUUIDGenerator.generateId());
        List nonTelemetryFields = datasetConfig.getFields().stream().filter(vf -> {
            BusinessEntityField entityField = entity.getFields().stream().filter(bef -> bef.getId().equals(vf.getEntityFieldId())).findFirst().get();
            return !FieldQueryType.TELEMETRY.equals((Object)entityField.getQuery().getQueryType());
        }).collect(Collectors.toList());
        ArrayList xFields = Lists.newArrayList();
        xFields.addAll(nonTelemetryFields);
        xFields.add(itemNameField);
        ViewConfig config = new ViewConfig();
        config.setId(TimeStampUUIDGenerator.generateId());
        config.setxAxis((List)xFields);
        config.setyAxis(Collections.emptyList());
        config.setSeries(Collections.emptyList());
        config.setSettings((JsonNode)NullNode.getInstance());
        config.setRowClickEntityId(businessEntityId);
        config.setRuntimeFilters(datasetConfig.getRuntimeFilters());
        config.setHiddenFields(datasetConfig.getHiddenFields());
        config.setCacheSettings(CacheSettings.builder().usePersistedCacheTelemetry(false).build());
        DatePickerConfig dateConf = new DatePickerConfig();
        dateConf.setStartTs(datasetConfig.getStartTs());
        dateConf.setEndTs(datasetConfig.getEndTs());
        config.setDatePickerConfig(dateConf);
        return config;
    }

    private List<DataRow> loadDataRowsForViewConfig(ViewConfig viewConfig, DatasetConfig datasetConfig) {
        boolean compleated;
        ViewTask viewTask = this.viewService.buildViewAsyncForModel(viewConfig, datasetConfig.getTenantId(), datasetConfig.getJwtToken());
        boolean bl = compleated = viewTask.isFinished() || viewTask.isCanceled();
        while (!compleated) {
            Optional opt = this.viewTaskCache.getTask(viewTask.getId());
            if (opt.isPresent()) {
                viewTask = (ViewTask)opt.get();
                compleated = viewTask.isFinished() || viewTask.isCanceled();
            } else {
                compleated = true;
                viewTask = null;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (viewTask == null || !viewTask.isFinished()) {
            throw new IllegalStateException("View task failed");
        }
        return viewTask.getResult().getRows();
    }

    private List<DataVector> mapRows(List<DataRow> rows, DatasetConfig config) {
        HashMap byItem = new HashMap();
        rows.forEach(r -> {
            List itemRows = byItem.computeIfAbsent(r.getEntityId(), i -> new ArrayList());
            itemRows.add(r);
        });
        ArrayList result = Lists.newArrayList();
        for (Map.Entry entry : byItem.entrySet()) {
            HashMap points = new HashMap();
            ((List)entry.getValue()).forEach(row -> {
                Map rowValues = this.mapRow(row, config);
                for (Map.Entry pointEntry : rowValues.entrySet()) {
                    List valueList = points.computeIfAbsent(pointEntry.getKey(), i -> new ArrayList());
                    valueList.add(pointEntry.getValue());
                }
            });
            DataVector dv = new DataVector();
            dv.setItemId(((DataRow)((List)entry.getValue()).get(0)).getEntityId().getId());
            dv.setItemName(((DataRow)((List)entry.getValue()).get(0)).getEntityName());
            points.values().forEach(l -> l.sort(Comparator.comparingLong(SimpleTsPoint::getTs)));
            dv.setPoints(points);
            result.add(dv);
        }
        return result;
    }

    private Map<UUID, SimpleTsPoint> mapRow(DataRow dataRow, DatasetConfig config) {
        HashMap points = new HashMap();
        dataRow.getCells().forEach(c -> points.put(c.getViewFieldId(), c.getData()));
        if (!points.containsKey(tsFieldId)) {
            return Collections.emptyMap();
        }
        long ts = Long.parseLong(points.get(tsFieldId).toString());
        HashMap<UUID, SimpleTsPoint> result = new HashMap<UUID, SimpleTsPoint>();
        for (ViewField field : config.getFields()) {
            if (!points.containsKey(field.getId())) continue;
            double val = (Double)points.get(field.getId());
            result.put(field.getId(), new SimpleTsPoint(ts, val));
        }
        return result;
    }
}

