/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.fetcher;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.ml.domain.DataVector;
import org.thingsboard.trendz.ml.fetcher.DatasetIterator;

public class DatasetIterator
implements Iterator<List<DataVector>> {
    private final FetchFunction fetchFunction;
    private final Queue<Item> unporcessedItems;
    private final List<Item> processedItems;

    public DatasetIterator(Set<Item> items, FetchFunction function) {
        this.fetchFunction = function;
        this.unporcessedItems = Lists.newLinkedList(items);
        this.processedItems = Lists.newArrayList();
    }

    @Override
    public boolean hasNext() {
        return this.unporcessedItems.size() > 0;
    }

    @Override
    public List<DataVector> next() {
        Item item = (Item)this.unporcessedItems.poll();
        List data = this.fetchFunction.fetch(item);
        this.processedItems.add(item);
        return data;
    }

    public int getProccessedSize() {
        return this.processedItems.size();
    }

    public int getUnproccessedSize() {
        return this.unporcessedItems.size();
    }
}

