/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.fetcher;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.DataRow;
import org.thingsboard.trendz.domain.runtime.ViewTask;
import org.thingsboard.trendz.ml.domain.DataVector;
import org.thingsboard.trendz.ml.domain.DatasetConfig;
import org.thingsboard.trendz.ml.domain.SimpleTsPoint;
import org.thingsboard.trendz.ml.fetcher.DatasetFetcher;
import org.thingsboard.trendz.ml.fetcher.DatasetIterator;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.view.ViewService;
import org.thingsboard.trendz.service.view.ViewTaskCache;

@Component
public class BaseDatasetFetcher
implements DatasetFetcher {
    private static final Logger log = LoggerFactory.getLogger(BaseDatasetFetcher.class);
    private static UUID tsFieldId = TimeStampUUIDGenerator.generateId();
    @Autowired
    private ViewService viewService;
    @Autowired
    private BusinessEntityService businessEntityService;
    @Autowired
    private ViewTaskCache viewTaskCache;

    public List<DataVector> fetchItemFieldFromDataset(DatasetConfig originalDataset, UUID viewFieldId, String itemName) {
        Optional<ViewField> optionalField = originalDataset.getFields().stream().filter(f -> f.getId().equals(viewFieldId)).findFirst();
        if (!optionalField.isPresent()) {
            throw new IllegalStateException("field Id not valid");
        }
        ViewField field = optionalField.get();
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(originalDataset.getTenantId(), field.getBusinessEntityId());
        BusinessEntityField entityNameField = businessEntity.getFields().stream().filter(f -> FieldQueryType.ENTITY_NAME.equals((Object)f.getQuery().getQueryType())).findFirst().get();
        Optional<ViewField> nameFilterOpt = originalDataset.getHiddenFields().stream().filter(f -> f.getEntityFieldId().equals(entityNameField.getId())).findFirst();
        if (nameFilterOpt.isPresent()) {
            ViewField itemFilterField = nameFilterOpt.get();
            RuntimeFilterField rff = originalDataset.getRuntimeFilters().stream().filter(f -> itemFilterField.getId().equals(f.getViewFieldId())).findFirst().get();
            rff.setSelection((Set)Sets.newHashSet((Object[])new String[]{itemName}));
            rff.setCondition(FilterCondition.ONE_OF);
        } else {
            ViewField itemFilterField = new ViewField();
            itemFilterField.setAggregationType(FieldAggregation.UNIQ);
            itemFilterField.setBusinessEntityId(businessEntity.getId());
            itemFilterField.setEntityFieldId(entityNameField.getId());
            itemFilterField.setId(TimeStampUUIDGenerator.generateId());
            itemFilterField.setHidden(true);
            RuntimeFilterField rff = new RuntimeFilterField();
            rff.setCondition(FilterCondition.ONE_OF);
            rff.setViewFieldId(itemFilterField.getId());
            rff.setSelection((Set)Sets.newHashSet((Object[])new String[]{itemName}));
            originalDataset.getHiddenFields().add(itemFilterField);
            originalDataset.getRuntimeFilters().add(rff);
        }
        return this.fetchDataset(originalDataset);
    }

    public List<DataVector> fetchDataset(DatasetConfig datasetConfig) {
        ViewConfig viewConfig = this.buildViewConfig(datasetConfig);
        List dataRows = this.loadDataRowsForViewConfig(viewConfig, datasetConfig);
        List dataVectors = this.mapRows(dataRows, datasetConfig);
        log.info("{} data vectors loaded from {} row", (Object)dataVectors.size(), (Object)dataRows.size());
        return dataVectors;
    }

    public DatasetIterator getDatasetIterator(DatasetConfig datasetConfig) {
        return new DatasetIterator(Collections.emptySet(), i -> Collections.emptyList());
    }

    private List<DataRow> loadDataRowsForViewConfig(ViewConfig viewConfig, DatasetConfig datasetConfig) {
        boolean compleated;
        ViewTask viewTask = this.viewService.buildViewAsyncForModel(viewConfig, datasetConfig.getTenantId(), datasetConfig.getJwtToken());
        boolean bl = compleated = viewTask.isFinished() || viewTask.isCanceled();
        while (!compleated) {
            Optional opt = this.viewTaskCache.getTask(viewTask.getId());
            if (opt.isPresent()) {
                viewTask = (ViewTask)opt.get();
                compleated = viewTask.isFinished() || viewTask.isCanceled();
            } else {
                compleated = true;
                viewTask = null;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (viewTask == null || !viewTask.isFinished()) {
            throw new IllegalStateException("View task failed");
        }
        return viewTask.getResult().getRows();
    }

    private List<DataVector> mapRows(List<DataRow> rows, DatasetConfig config) {
        HashMap byItem = new HashMap();
        rows.forEach(r -> {
            List itemRows = byItem.computeIfAbsent(r.getEntityId(), i -> new ArrayList());
            itemRows.add(r);
        });
        ArrayList result = Lists.newArrayList();
        for (Map.Entry entry : byItem.entrySet()) {
            HashMap points = new HashMap();
            ((List)entry.getValue()).forEach(row -> {
                Map rowValues = this.mapRow(row, config);
                for (Map.Entry pointEntry : rowValues.entrySet()) {
                    List valueList = points.computeIfAbsent(pointEntry.getKey(), i -> new ArrayList());
                    valueList.add(pointEntry.getValue());
                }
            });
            DataVector dv = new DataVector();
            dv.setItemId(((DataRow)((List)entry.getValue()).get(0)).getEntityId().getId());
            dv.setItemName(((DataRow)((List)entry.getValue()).get(0)).getEntityName());
            points.values().forEach(l -> l.sort(Comparator.comparingLong(SimpleTsPoint::getTs)));
            dv.setPoints(points);
            result.add(dv);
        }
        return result;
    }

    private Map<UUID, SimpleTsPoint> mapRow(DataRow dataRow, DatasetConfig config) {
        HashMap points = new HashMap();
        dataRow.getCells().forEach(c -> points.put(c.getViewFieldId(), c.getData()));
        if (!points.containsKey(tsFieldId)) {
            return Collections.emptyMap();
        }
        long ts = Long.parseLong(points.get(tsFieldId).toString());
        HashMap<UUID, SimpleTsPoint> result = new HashMap<UUID, SimpleTsPoint>();
        for (ViewField field : config.getFields()) {
            if (!points.containsKey(field.getId())) continue;
            double val = (Double)points.get(field.getId());
            result.put(field.getId(), new SimpleTsPoint(ts, val));
        }
        return result;
    }

    private ViewConfig buildViewConfig(DatasetConfig datasetConfig) {
        Set businessEntityIds = datasetConfig.getFields().stream().map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
        if (businessEntityIds.size() != 1) {
            throw new IllegalStateException("Fields from multiple Business Entities are not supported");
        }
        UUID businessEntityId = (UUID)businessEntityIds.iterator().next();
        BusinessEntity entity = this.businessEntityService.findEntityById(datasetConfig.getTenantId(), businessEntityId);
        BusinessEntityField entityNameField = entity.getFields().stream().filter(f -> f.getQuery().getQueryType().equals((Object)FieldQueryType.ENTITY_NAME)).findFirst().get();
        ViewField itemNameField = new ViewField();
        itemNameField.setAggregationType(FieldAggregation.UNIQ);
        itemNameField.setBusinessEntityId(entity.getId());
        itemNameField.setEntityFieldId(entityNameField.getId());
        itemNameField.setId(TimeStampUUIDGenerator.generateId());
        ViewField tsField = new ViewField();
        tsField.setId(tsFieldId);
        tsField.setVirtualDateField(true);
        tsField.setDateGrouping(DateAggregationType.RAW);
        ArrayList xFields = Lists.newArrayList();
        xFields.addAll(datasetConfig.getFields());
        xFields.add(itemNameField);
        xFields.add(tsField);
        ViewConfig config = new ViewConfig();
        config.setId(TimeStampUUIDGenerator.generateId());
        config.setxAxis((List)xFields);
        config.setyAxis(Collections.emptyList());
        config.setSeries(Collections.emptyList());
        config.setSettings((JsonNode)NullNode.getInstance());
        config.setRowClickEntityId(businessEntityId);
        config.setRuntimeFilters(datasetConfig.getRuntimeFilters());
        config.setHiddenFields(datasetConfig.getHiddenFields());
        DatePickerConfig dateConf = new DatePickerConfig();
        dateConf.setStartTs(datasetConfig.getStartTs());
        dateConf.setEndTs(datasetConfig.getEndTs());
        config.setDatePickerConfig(dateConf);
        return config;
    }
}

