/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.features;

import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.domain.ComplexTsPoint;

@Component
public class TsFeatureExtractor {
    private static final Logger log = LoggerFactory.getLogger(TsFeatureExtractor.class);

    public double[] extract(List<ComplexTsPoint> points, Set<UUID> fieldIds) {
        ArrayList features = Lists.newArrayList();
        for (UUID fieldId : fieldIds) {
            List values = points.stream().map(cp -> (Double)cp.getValues().get(fieldId)).collect(Collectors.toList());
            features.addAll(this.getRegressionFeatures(points, fieldId));
            features.add(values.stream().mapToDouble(d -> d).max().orElse(0.0));
            features.add(values.stream().mapToDouble(d -> d).min().orElse(0.0));
            features.add(values.stream().mapToDouble(d -> d).average().orElse(0.0));
        }
        return Doubles.toArray((Collection)features);
    }

    private List<Double> getRegressionFeatures(List<ComplexTsPoint> points, UUID fieldId) {
        ArrayList features = Lists.newArrayList();
        SimpleRegression sr = new SimpleRegression();
        for (ComplexTsPoint record : points) {
            sr.addData((double)record.getTs(), ((Double)record.getValues().get(fieldId)).doubleValue());
        }
        features.add(sr.getSlope());
        features.add(sr.getMeanSquareError());
        return features;
    }
}

