/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.features;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.domain.ComplexTsPoint;
import org.thingsboard.trendz.ml.domain.FeatureStatistic;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.Segment;
import org.thingsboard.trendz.ml.features.TsFeatureExtractor;
import org.thingsboard.trendz.ml.segment.AggregateReducer;

@Component
public class FeatureBuilder {
    private static final Logger log = LoggerFactory.getLogger(FeatureBuilder.class);
    @Autowired
    private TsFeatureExtractor featureExtractor;
    @Autowired
    private AggregateReducer aggregateReducer;

    public List<Segment> buildFeatures(List<Segment> segments, MlProperties.FeatureBuilderProperties properties) {
        if (MlProperties.FeatureBuilderType.FEATURE.equals((Object)properties.getType())) {
            return this.computeFeatures(segments, properties);
        }
        if (MlProperties.FeatureBuilderType.DISTANCE.equals((Object)properties.getType())) {
            List reducedSegments = this.reducePoints(segments, properties.getAggregatedIntervals(), properties.getAgg(), properties);
            return reducedSegments;
        }
        throw new IllegalStateException("Unsupported method type " + properties.getType());
    }

    private List<Segment> computeFeatures(List<Segment> segments, MlProperties.FeatureBuilderProperties properties) {
        segments.forEach(s -> {
            List normalizedPoints = this.normalizeValues(s.getRecords(), properties.getFieldStatistic());
            double[] features = this.featureExtractor.extract(normalizedPoints, properties.getFieldStatistic().keySet());
            s.setFeatures(features);
        });
        return segments;
    }

    private List<Segment> reducePoints(List<Segment> segments, int requiredSize, MlProperties.FeatureAggregation aggregation, MlProperties.FeatureBuilderProperties properties) {
        Set fieldIds = segments.stream().flatMap(s -> s.getRecords().stream()).flatMap(p -> p.getValues().keySet().stream()).collect(Collectors.toSet());
        segments.forEach(segment -> {
            List reducedPoints = this.aggregateReducer.reduce(segment.getRecords(), fieldIds, requiredSize, aggregation);
            segment.setRecords(reducedPoints);
        });
        segments.forEach(segment -> {
            List normalizedPoints = this.normalizeValues(segment.getRecords(), properties.getFieldStatistic());
            int i = 0;
            double[] features = new double[normalizedPoints.size() * fieldIds.size()];
            for (ComplexTsPoint point : normalizedPoints) {
                for (UUID fieldId : fieldIds) {
                    features[i] = (Double)point.getValues().get(fieldId);
                    ++i;
                }
            }
            segment.setFeatures(features);
        });
        return segments;
    }

    private List<ComplexTsPoint> normalizeValues(List<ComplexTsPoint> original, Map<UUID, FeatureStatistic> fieldStatistic) {
        List<ComplexTsPoint> normalizedPoints = original.stream().map(r -> {
            ComplexTsPoint newPoint = new ComplexTsPoint();
            newPoint.setTs(r.getTs());
            for (Map.Entry entry : fieldStatistic.entrySet()) {
                UUID fieldId = (UUID)entry.getKey();
                FeatureStatistic stats = (FeatureStatistic)entry.getValue();
                Double originalValue = (Double)r.getValues().get(fieldId);
                double normalisedValue = 0.0;
                if (originalValue != null) {
                    normalisedValue = (originalValue - stats.getAvg()) / (stats.getMax() - stats.getMin());
                }
                newPoint.getValues().put(fieldId, normalisedValue);
            }
            return newPoint;
        }).collect(Collectors.toList());
        return normalizedPoints;
    }
}

