/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.distance;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.ml.distance.DTW;

public class DtwDistance
implements DistanceMeasure {
    private static final Logger log = LoggerFactory.getLogger(DtwDistance.class);
    private Map<Pair<List<Double>, List<Double>>, Double> distanceCache = new ConcurrentHashMap();
    private AtomicLong dtwOperations = new AtomicLong();
    private AtomicLong cacheHits = new AtomicLong();

    public double compute(double[] a, double[] b) {
        long operations = this.dtwOperations.incrementAndGet();
        if (operations % 1000000L == 0L) {
            log.info("DTW operations {}", (Object)operations);
        }
        DTW dtw = new DTW();
        DTW.Result result = dtw.compute(a, b);
        double distance = result.getDistance();
        return distance;
    }
}

