/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.distance;

import org.thingsboard.trendz.ml.distance.DTW;

public class DTW {
    public Result compute(double[] pSample, double[] pTemplate) {
        int j;
        int i;
        int lN = pSample.length;
        int lM = pTemplate.length;
        if (lN == 0 || lM == 0) {
            return new Result((int[][])new int[0][], Double.NaN);
        }
        int lK = 1;
        int[][] lWarpingPath = new int[lN + lM][2];
        double[][] lL = new double[lN][lM];
        double[][] lG = new double[lN][lM];
        double[] lMinimaBuffer = new double[3];
        for (i = 0; i < lN; ++i) {
            double lSample = pSample[i];
            for (j = 0; j < lM; ++j) {
                lL[i][j] = this.getDistanceBetween(lSample, pTemplate[j]);
            }
        }
        lG[0][0] = lL[0][0];
        for (i = 1; i < lN; ++i) {
            lG[i][0] = lL[i][0] + lG[i - 1][0];
        }
        for (j = 1; j < lM; ++j) {
            lG[0][j] = lL[0][j] + lG[0][j - 1];
        }
        for (i = 1; i < lN; ++i) {
            for (j = 1; j < lM; ++j) {
                lG[i][j] = Math.min(Math.min(lG[i - 1][j], lG[i - 1][j - 1]), lG[i][j - 1]) + lL[i][j];
            }
        }
        int n = lN - 1;
        lWarpingPath[lK - 1][0] = n;
        i = n;
        int n2 = lM - 1;
        lWarpingPath[lK - 1][1] = n2;
        j = n2;
        while (i + j != 0) {
            if (i != 0 && j != 0) {
                lMinimaBuffer[0] = lG[i - 1][j];
                lMinimaBuffer[1] = lG[i][j - 1];
                lMinimaBuffer[2] = lG[i - 1][j - 1];
                int lMinimumIndex = this.getMinimumIndex(lMinimaBuffer);
                boolean lMinIs0 = lMinimumIndex == 0;
                boolean lMinIs1 = lMinimumIndex == 1;
                boolean lMinIs2 = lMinimumIndex == 2;
                i -= lMinIs0 || lMinIs2 ? 1 : 0;
                j -= lMinIs1 || lMinIs2 ? 1 : 0;
            }
            lWarpingPath[++lK - 1][0] = --i;
            lWarpingPath[lK - 1][1] = --j;
        }
        return new Result(this.reverse(lWarpingPath, lK), lG[lN - 1][lM - 1] / (double)lK);
    }

    private int[][] reverse(int[][] pPath, int pK) {
        int[][] lPath = new int[pK][2];
        for (int i = 0; i < pK; ++i) {
            for (int j = 0; j < 2; ++j) {
                lPath[i][j] = pPath[pK - i - 1][j];
            }
        }
        return lPath;
    }

    protected double getDistanceBetween(double p1, double p2) {
        return (p1 - p2) * (p1 - p2);
    }

    protected final int getMinimumIndex(double[] pArray) {
        int lIndex = 0;
        double lValue = pArray[0];
        for (int i = 1; i < pArray.length; ++i) {
            boolean lIsSmaller = pArray[i] < lValue;
            lValue = lIsSmaller ? pArray[i] : lValue;
            lIndex = lIsSmaller ? i : lIndex;
        }
        return lIndex;
    }
}

