/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.cluster;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.cluster.CustomDistanceClusterer;
import org.thingsboard.trendz.ml.cluster.LoggedKMean;
import org.thingsboard.trendz.ml.cluster.SegmentClusterer;
import org.thingsboard.trendz.ml.domain.ClusterableSegment;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.Segment;

@Component
public class CustomDistanceClusterer
implements SegmentClusterer {
    private static final Logger log = LoggerFactory.getLogger(CustomDistanceClusterer.class);

    public List<CentroidCluster<ClusterableSegment>> cluster(List<Segment> segments, DistanceMeasure distanceMeasure, MlProperties.ClusteringProperties properties) {
        int clustersCount = properties.getClustersCount();
        List clusterInput = segments.stream().map(ClusterableSegment::new).collect(Collectors.toList());
        ArrayList dataPoints = Lists.newArrayList();
        for (int i = 0; i < clusterInput.size(); ++i) {
            CustomDataPoint dataPoint = new CustomDataPoint(this, i, (ClusterableSegment)clusterInput.get(i));
            dataPoints.add(dataPoint);
        }
        HashMap<Integer, List> partitionedClusters = new HashMap<Integer, List>();
        int i = 0;
        for (List partitionDS : Lists.partition((List)dataPoints, (int)1000)) {
            List clusters = this.fit(partitionDS, clustersCount, distanceMeasure);
            partitionedClusters.put(i, clusters);
            partitionDS.forEach(p -> {
                p.distanceDetails = null;
            });
            ++i;
        }
        return this.mergeClusters(partitionedClusters, properties, distanceMeasure);
    }

    private List<CentroidCluster<ClusterableSegment>> mergeClusters(Map<Integer, List<CentroidCluster<ClusterableSegment>>> partitionedClusters, MlProperties.ClusteringProperties properties, DistanceMeasure distanceMeasure) {
        List clusterables = partitionedClusters.values().stream().flatMap(l -> l.stream()).map(cc -> new ClusterableSegmentsCollection(cc.getPoints(), cc.getCenter().getPoint())).collect(Collectors.toList());
        LoggedKMean clusterer = new LoggedKMean(properties.getClustersCount(), 20, distanceMeasure);
        List cluster = clusterer.cluster(clusterables);
        List<CentroidCluster<ClusterableSegment>> finalCentroids = cluster.stream().map(c -> {
            List collect = c.getPoints().stream().flatMap(csc -> csc.getSegments().stream()).collect(Collectors.toList());
            CentroidCluster cc = new CentroidCluster(c.getCenter());
            cc.getPoints().addAll(collect);
            return cc;
        }).collect(Collectors.toList());
        return finalCentroids;
    }

    private List<CentroidCluster<ClusterableSegment>> fit(List<CustomDataPoint> dataset, int clustersCount, DistanceMeasure distanceMeasure) {
        this.calculateDistances(dataset, distanceMeasure);
        ArrayList centroids = Lists.newArrayList();
        for (int i = 0; i < clustersCount; ++i) {
            centroids.add(this.getCentroid(dataset.stream().filter(ds -> !ds.used).collect(Collectors.toList())));
        }
        HashMap<CustomDataPoint, CentroidCluster> map = new HashMap<CustomDataPoint, CentroidCluster>();
        for (CustomDataPoint dataPoint : dataset) {
            CustomDataPoint closestCentroid = null;
            double closestDistance = Double.MAX_VALUE;
            for (CustomDataPoint centroid : centroids) {
                DistanceDetails distanceDetails = centroid.distanceDetails.stream().filter(dd -> dd.toId == dataPoint.id).findFirst().get();
                if (!(distanceDetails.distance < closestDistance)) continue;
                closestCentroid = centroid;
                closestDistance = distanceDetails.distance;
            }
            CentroidCluster cluster = map.computeIfAbsent(closestCentroid, d -> new CentroidCluster((Clusterable)d.segment));
            cluster.addPoint((Clusterable)dataPoint.segment);
        }
        log.info("{} centroids found", (Object)centroids.size());
        return Lists.newArrayList(map.values());
    }

    private void calculateDistances(List<CustomDataPoint> dataset, DistanceMeasure dtwDistance) {
        AtomicLong counter = new AtomicLong();
        AtomicInteger operations = new AtomicInteger();
        for (CustomDataPoint point : dataset) {
            dataset.stream().forEach(otherPoint -> {
                double distance = dtwDistance.compute(point.segment.getPoint(), otherPoint.segment.getPoint());
                DistanceDetails distanceDetails = new DistanceDetails(this, point.id, otherPoint.id, distance);
                point.distanceDetails.add(distanceDetails);
                operations.incrementAndGet();
                if (counter.incrementAndGet() % 1000000L == 0L) {
                    log.info("already perfromed {}", (Object)counter.get());
                }
            });
        }
        log.info("Operations performed {}. Waiting for {}", (Object)operations.get(), (Object)(dataset.size() * dataset.size()));
        log.info("Operations finised {}", (Object)operations.get());
        dataset.forEach(dp -> dp.distanceDetails.sort(Comparator.comparingDouble(dd -> dd.distance)));
    }

    private CustomDataPoint getCentroid(List<CustomDataPoint> dataset) {
        double minEps = Double.MAX_VALUE;
        CustomDataPoint centroid = dataset.get(0);
        int checkIndex = (int)((double)dataset.size() * 0.1);
        for (CustomDataPoint dataPoint : dataset.stream().filter(ds -> !ds.used).collect(Collectors.toList())) {
            int index;
            List distanceDetailsList = dataPoint.distanceDetails.stream().filter(dd -> !dd.used).collect(Collectors.toList());
            int n = index = checkIndex < distanceDetailsList.size() ? checkIndex : distanceDetailsList.size();
            double distance = ((DistanceDetails)distanceDetailsList.get((int)index)).distance;
            if (!(minEps > distance)) continue;
            minEps = distance;
            centroid = dataPoint;
        }
        log.info("Cluster start for Eps {}", (Object)minEps);
        HashSet excludeFromClusterIds = Sets.newHashSet();
        double finalMinEps = minEps;
        for (DistanceDetails distanceDetails : centroid.distanceDetails.stream().filter(dd -> !dd.used).filter(dd -> dd.distance <= finalMinEps).collect(Collectors.toList())) {
            Optional<CustomDataPoint> any = dataset.stream().filter(ds -> !ds.used).filter(ds -> ds.id == distanceDetails.toId).filter(ds -> {
                int index = 0;
                for (DistanceDetails details : ds.distanceDetails.stream().filter(dd -> !dd.used).collect(Collectors.toList())) {
                    if (details.toId == distanceDetails.fromId) break;
                    ++index;
                }
                return index <= checkIndex;
            }).findAny();
            if (any.isPresent()) continue;
            excludeFromClusterIds.add(distanceDetails.toId);
        }
        HashSet alreadyProcessedIds = Sets.newHashSet();
        alreadyProcessedIds.add(centroid.id);
        Iterator iterator = centroid.distanceDetails.stream().filter(dd -> !dd.used).filter(dd -> !excludeFromClusterIds.contains(dd.toId)).collect(Collectors.toList()).iterator();
        DistanceDetails next = (DistanceDetails)iterator.next();
        int clusterSize = 1;
        while (next.distance <= minEps && iterator.hasNext()) {
            alreadyProcessedIds.add(next.toId);
            next.used = true;
            next = (DistanceDetails)iterator.next();
            ++clusterSize;
        }
        int originalSize = dataset.size();
        dataset.forEach(point -> {
            if (alreadyProcessedIds.contains(point.id)) {
                point.used = true;
            }
        });
        for (CustomDataPoint dataPoint : dataset) {
            for (DistanceDetails details : dataPoint.distanceDetails) {
                if (!alreadyProcessedIds.contains(details.toId)) continue;
                details.used = true;
            }
        }
        log.info("Centroid found. Possible cluster size {}. Cleared datapoints {}", (Object)clusterSize, (Object)(originalSize - dataset.size()));
        return centroid;
    }
}

